/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.uniquedb.builder;

import com.dataiku.geoip.uniquedb.builder.Buildable;
import com.dataiku.geoip.uniquedb.builder.GrowableIntArray;
import com.dataiku.geoip.uniquedb.builder.UniqueDBBuilder;

public class NodeBuilder
extends Buildable {
    protected GrowableIntArray storage = new GrowableIntArray();
    private boolean deduplicate = true;
    private boolean storeSize = true;

    public NodeBuilder add(NodeBuilder array) {
        if (array.getDatabase() != this.getDatabase()) {
            throw new IllegalArgumentException("Cannot add a node from another UniqueDBBuilder");
        }
        Integer index = null;
        if (this.deduplicate) {
            index = this.getDatabase().map.get(array.storage);
        }
        if (index == null) {
            if (array.storeSize) {
                this.getDatabase().meta.add(array.storage.size());
            }
            index = this.getDatabase().meta.size();
            for (int i = 0; i < array.storage.size(); ++i) {
                this.getDatabase().meta.add(array.storage.get(i));
            }
            if (this.deduplicate) {
                this.getDatabase().map.put(array.storage.clone(), index);
            }
        }
        this.storage.add(index);
        return this;
    }

    public NodeBuilder withSize(boolean v) {
        this.storeSize = v;
        return this;
    }

    public NodeBuilder withDeduplication(boolean v) {
        this.deduplicate = v;
        return this;
    }

    public NodeBuilder add(Buildable b) {
        if (b != null) {
            if (b.getDatabase() != this.getDatabase()) {
                throw new IllegalArgumentException("Cannot add a node from another UniqueDBBuilder");
            }
            this.add(b.build());
        } else {
            this.storage.add(-1);
        }
        return this;
    }

    public int size() {
        return this.storage.size();
    }

    public NodeBuilder add(String string) {
        if (string == null) {
            this.storage.add(-1);
        } else {
            Integer index = this.getDatabase().map.get(string);
            if (index == null) {
                index = this.getDatabase().meta.size();
                this.getDatabase().meta.add(this.getDatabase().data.length());
                this.getDatabase().data.append(string);
                this.getDatabase().meta.add(this.getDatabase().data.length());
                this.getDatabase().map.put(string, index);
            }
            this.storage.add(index);
        }
        return this;
    }

    public NodeBuilder add(int value) {
        this.storage.add(value);
        return this;
    }

    public NodeBuilder(UniqueDBBuilder db) {
        super(db);
    }

    @Override
    protected NodeBuilder build() {
        return this;
    }

    public NodeBuilder clone() {
        return new NodeBuilder(this.getDatabase(), this.storage.clone(), this.storeSize, this.deduplicate);
    }

    private NodeBuilder(UniqueDBBuilder db, GrowableIntArray storage, boolean storeSize, boolean deduplicate) {
        super(db);
        this.storage = storage;
        this.storeSize = storeSize;
        this.deduplicate = deduplicate;
    }
}

