/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.data.geo.GeoPointUtils;
import com.dataiku.dip.shaker.processors.geo.GeoDistanceProcessor;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Function;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class GeoDistance
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 3) {
            Object o1 = args[0];
            Object o2 = args[1];
            Object o3 = args[2];
            if (o1 instanceof String && o2 instanceof String && o3 instanceof String && !StringUtils.isBlank((String)((String)o1)) && !StringUtils.isBlank((String)((String)o2)) && GeoDistanceProcessor.DistanceUnit.getDistanceUnitByName((String)o3) != null) {
                GeoPoint.Coords coords1 = GeoPoint.convert((String)o1);
                GeoPoint.Coords coords2 = GeoPoint.convert((String)o2);
                GeoDistanceProcessor.DistanceUnit unit = GeoDistanceProcessor.DistanceUnit.getDistanceUnitByName((String)o3);
                return GeoPointUtils.computeDistance(coords1, coords2, unit);
            }
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoDistance.DOCUMENTATION", "Compute the distance between two geographical points. The available units are: KILOMETERS, MILES.").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withParams("string geopoint1, string geopoint2, string unit").withReturns("number");
    }
}

