/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.ast;

import com.google.gson.JsonObject;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.HasFields;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class FieldAccessorExpr
implements Evaluable {
    public final Evaluable _inner;
    public final String _fieldName;

    public FieldAccessorExpr(Evaluable inner, String fieldName) {
        this._inner = inner;
        this._fieldName = fieldName;
    }

    @Override
    public Object evaluate(Properties bindings) {
        Object o = this._inner.evaluate(bindings);
        if (ExpressionUtils.isError(o)) {
            return o;
        }
        if (o == null) {
            return new EvalError("Cannot retrieve field from null");
        }
        if (o instanceof HasFields) {
            return ((HasFields)o).getField(this._fieldName, bindings);
        }
        if (o instanceof JSONObject) {
            try {
                return ((JSONObject)o).get(this._fieldName);
            }
            catch (JSONException e) {
                return new EvalError("Object does not have any field, including " + this._fieldName);
            }
        }
        if (o instanceof JsonObject) {
            return ((JsonObject)o).get(this._fieldName);
        }
        return new EvalError("Object does not have any field, including " + this._fieldName);
    }

    public String toString() {
        return this._inner.toString() + "." + this._fieldName;
    }
}

