/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.security.auth.APIAuthUtilsBase;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EnvironmentBasedBasicAuthFilter
implements Filter {
    private final String username = System.getenv("DKU_BASIC_AUTH_FILTER_USER");
    private final String password = System.getenv("DKU_BASIC_AUTH_FILTER_PASSWORD");
    private final String realm = "Protected";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (this.username == null) {
            throw new ServletException("no username");
        }
        if (this.password == null) {
            throw new ServletException("no password");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        APIAuthUtilsBase.BasicCredential cred = APIAuthUtilsBase.decodeBasicAuthentication((String)request.getHeader("Authorization"));
        if (cred == null) {
            throw new ServletException("no cred");
        }
        if (!this.username.equals(cred.user) || !this.password.equals(cred.password)) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Protected\"");
            response.sendError(401, "Bad credentials");
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

