/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl;

import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.SharedStringsImplementationType;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.StreamingReader;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.XmlUtils;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.ExcelRuntimeException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.MissingSheetException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.NotSupportedException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.OpenException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.ParseException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.exceptions.ReadException;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.PoiSharedStringsSupport;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.StreamingSheet;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.StreamingSheetReader;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.StreamingWorkbook;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.TempFileUtil;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.WorkbookUtil;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml.OoxmlReader;
import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml.OoxmlStrictHelper;
import com.dataiku.dss.shadelibpoi.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.UnsupportedFileFormatException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ooxml.POIXMLProperties;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.OPCPackage;
import com.dataiku.dss.shadelibpoi.org.apache.poi.openxml4j.opc.PackagePart;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.Decryptor;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.dataiku.dss.shadelibpoi.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Date1904Support;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Sheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.model.SharedStrings;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.model.StylesTable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.model.ThemesTable;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFShape;
import com.dataiku.dss.shadelibpoi.org.slf4j.Logger;
import com.dataiku.dss.shadelibpoi.org.slf4j.LoggerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StreamingWorkbookReader
implements Iterable<Sheet>,
Date1904Support,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingWorkbookReader.class);
    private List<StreamingSheet> sheets;
    private final Map<Integer, StreamingSheet> sheetMap = new HashMap<Integer, StreamingSheet>();
    private final List<Map<String, String>> sheetProperties = new ArrayList<Map<String, String>>();
    private final Map<String, List<XSSFShape>> shapeMap = new HashMap<String, List<XSSFShape>>();
    private final StreamingReader.Builder builder;
    private File tmp;
    private OPCPackage pkg;
    private SharedStrings sst;
    private StylesTable styles;
    private boolean use1904Dates = false;
    private boolean strictFormat = false;
    private StreamingWorkbook workbook = null;
    private POIXMLProperties.CoreProperties coreProperties = null;
    private OoxmlReader ooxmlReader;

    public StreamingWorkbookReader(StreamingReader.Builder builder) {
        this.builder = builder;
    }

    public void init(InputStream is) throws OpenException, ReadException, ParseException {
        if (this.builder.avoidTempFiles()) {
            try {
                if (this.builder.getPassword() != null) {
                    POIFSFileSystem poifs = new POIFSFileSystem(is);
                    this.pkg = this.decryptWorkbook(poifs);
                } else {
                    this.pkg = OPCPackage.open(is);
                }
                this.loadPackage(this.pkg);
            }
            catch (SAXException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ParseException("Failed to parse stream", e);
            }
            catch (IOException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new OpenException("Failed to open stream", e);
            }
            catch (GeneralSecurityException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ReadException("Unable to read workbook - Decryption failed", e);
            }
            catch (OpenXML4JException | RuntimeException | XMLStreamException e) {
                IOUtils.closeQuietly((Closeable)this.pkg);
                throw new ReadException("Unable to read workbook", e);
            }
        }
        File f = null;
        try {
            f = TempFileUtil.writeInputStreamToFile(is, this.builder.getBufferSize());
            if (log.isDebugEnabled()) {
                log.debug("Created temp file [{}]", (Object)f.getAbsolutePath());
            }
            this.init(f);
            this.tmp = f;
        }
        catch (OpenException | ReadException e) {
            if (f != null && !f.delete()) {
                log.debug("failed to delete temp file");
            }
            throw e;
        }
        catch (UnsupportedFileFormatException e) {
            if (f != null && !f.delete()) {
                log.debug("failed to delete temp file");
            }
            throw new ReadException("Unsupported File Format (only xlsx files are supported)", e);
        }
        catch (IOException | RuntimeException e) {
            if (f != null && !f.delete()) {
                log.debug("failed to delete temp file");
            }
            throw new ReadException("Unable to read input stream", e);
        }
    }

    public void init(File f) throws OpenException, ReadException, ParseException {
        try {
            if (this.builder.getPassword() != null) {
                POIFSFileSystem poifs = new POIFSFileSystem(f);
                this.pkg = this.decryptWorkbook(poifs);
            } else {
                this.pkg = OPCPackage.open(f);
            }
            this.loadPackage(this.pkg);
        }
        catch (SAXException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ParseException("Failed to parse file", e);
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new OpenException("Failed to open file", e);
        }
        catch (UnsupportedFileFormatException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unsupported File Format (only xlsx files are supported)", e);
        }
        catch (OpenXML4JException | XMLStreamException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unable to read workbook", e);
        }
        catch (GeneralSecurityException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unable to read workbook - Decryption failed", e);
        }
        catch (ExcelRuntimeException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw e;
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly((Closeable)this.pkg);
            throw new ReadException("Unable to read workbook", e);
        }
    }

    private OPCPackage decryptWorkbook(POIFSFileSystem poifs) throws IOException, GeneralSecurityException, InvalidFormatException {
        EncryptionInfo info = new EncryptionInfo(poifs);
        Decryptor d = Decryptor.getInstance(info);
        d.verifyPassword(this.builder.getPassword());
        return OPCPackage.open(d.getDataStream(poifs));
    }

    private void loadPackage(OPCPackage pkg) throws IOException, OpenXML4JException, SAXException, XMLStreamException {
        this.strictFormat = pkg.isStrictOoxmlFormat();
        this.ooxmlReader = new OoxmlReader(this.builder, pkg, this.strictFormat);
        if (this.strictFormat) {
            log.info("file is in strict OOXML format");
        }
        Document workbookDoc = XmlUtils.readDocument(this.ooxmlReader.getWorkbookData());
        this.use1904Dates = WorkbookUtil.use1904Dates(workbookDoc);
        this.lookupSheetNames(workbookDoc);
        if (this.builder.getSharedStringsImplementationType() == SharedStringsImplementationType.TEMP_FILE_BACKED) {
            log.info("Created sst cache file");
            this.sst = PoiSharedStringsSupport.createTempFileSharedStringsTable(pkg, this.builder);
        } else {
            this.sst = this.builder.getSharedStringsImplementationType() == SharedStringsImplementationType.CUSTOM_MAP_BACKED ? PoiSharedStringsSupport.createMapBackedSharedStringsTable(pkg, this.builder) : (this.strictFormat ? OoxmlStrictHelper.getSharedStringsTable(this.builder, pkg) : this.ooxmlReader.getSharedStrings(this.builder));
        }
        if (this.builder.readCoreProperties()) {
            try {
                POIXMLProperties xmlProperties = new POIXMLProperties(pkg);
                this.coreProperties = xmlProperties.getCoreProperties();
            }
            catch (Exception e) {
                log.warn("Failed to read coreProperties", e);
            }
        }
        if (this.builder.readStyles()) {
            if (this.strictFormat) {
                ThemesTable themesTable = OoxmlStrictHelper.getThemesTable(this.builder, pkg);
                this.styles = OoxmlStrictHelper.getStylesTable(this.builder, pkg);
                if (this.styles != null) {
                    this.styles.setTheme(themesTable);
                }
            } else {
                this.styles = this.ooxmlReader.getStylesTable();
            }
        }
    }

    void setWorkbook(StreamingWorkbook workbook) {
        this.workbook = workbook;
        workbook.setCoreProperties(this.coreProperties);
    }

    Workbook getWorkbook() {
        return this.workbook;
    }

    private List<StreamingSheet> loadSheets() {
        ArrayList<StreamingSheet> sheetList = new ArrayList<StreamingSheet>();
        int numSheets = this.ooxmlReader.getNumberOfSheets();
        for (int i = 0; i < numSheets; ++i) {
            StreamingSheet maybeSheet = this.sheetMap.get(i);
            sheetList.add(maybeSheet == null ? this.createSheet(i) : maybeSheet);
        }
        this.sheetMap.clear();
        return sheetList;
    }

    public StreamingSheet getSheetAt(int idx) throws MissingSheetException, IOException, XMLStreamException {
        if (this.sheets != null && this.sheets.size() > idx) {
            return this.sheets.get(idx);
        }
        StreamingSheet sheet = this.sheetMap.get(idx);
        if (sheet == null) {
            sheet = this.createSheet(idx);
            this.sheetMap.put(idx, sheet);
        }
        return sheet;
    }

    public StreamingSheet getSheet(String name) throws MissingSheetException, IOException, XMLStreamException {
        int idx = this.ooxmlReader.getSheetIndex(name);
        return this.getSheetAt(idx);
    }

    private StreamingSheet createSheet(int idx) throws MissingSheetException {
        PackagePart part;
        OoxmlReader.SheetData sheetData = this.ooxmlReader.getSheetDataAt(idx);
        if (this.builder.readShapes()) {
            this.shapeMap.put(sheetData.getSheetName(), sheetData.getShapes());
        }
        if ((part = sheetData.getSheetPart()) == null) {
            throw new MissingSheetException("Sheet at index " + idx + " is missing");
        }
        return new StreamingSheet(this.sheetProperties.get(idx).get("name"), new StreamingSheetReader(this, part, this.sst, this.styles, sheetData.getComments(), this.use1904Dates, this.builder.getRowCacheSize()));
    }

    private void lookupSheetNames(Document workbookDoc) {
        this.sheetProperties.clear();
        NodeList nl = XmlUtils.searchForNodeList(workbookDoc, "/ss:workbook/ss:sheets/ss:sheet");
        for (int i = 0; i < nl.getLength(); ++i) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("name", nl.item(i).getAttributes().getNamedItem("name").getTextContent());
            Node state = nl.item(i).getAttributes().getNamedItem("state");
            props.put("state", state == null ? "visible" : state.getTextContent());
            this.sheetProperties.add(props);
        }
    }

    List<StreamingSheet> getSheets() throws XMLStreamException, IOException {
        if (this.sheets == null) {
            this.sheets = this.loadSheets();
        }
        return this.sheets;
    }

    public List<Map<String, String>> getSheetProperties() {
        return this.sheetProperties;
    }

    @Override
    public Iterator<Sheet> iterator() throws ReadException {
        try {
            return new StreamingSheetIterator(this.getSheets().iterator());
        }
        catch (IOException | XMLStreamException e) {
            throw new ReadException(e);
        }
    }

    @Override
    public Spliterator<Sheet> spliterator() throws ReadException {
        try {
            return Spliterators.spliterator(this.getSheets(), 16);
        }
        catch (IOException | XMLStreamException e) {
            throw new ReadException(e);
        }
    }

    @Override
    public boolean isDate1904() {
        return this.use1904Dates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.sheets != null) {
                for (StreamingSheet sheet : this.sheets) {
                    sheet.getReader().close();
                }
            }
        }
        finally {
            try {
                this.pkg.revert();
                this.pkg.close();
            }
            finally {
                if (this.tmp != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Deleting tmp file [{}]", (Object)this.tmp.getAbsolutePath());
                    }
                    if (!this.tmp.delete()) {
                        log.debug("Failed tp delete temp file");
                    }
                }
                if (this.sst instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)this.sst)).close();
                    }
                    catch (Exception e) {
                        log.warn("Failed to close sst", e);
                    }
                }
            }
        }
    }

    StreamingReader.Builder getBuilder() {
        return this.builder;
    }

    OPCPackage getOPCPackage() {
        return this.pkg;
    }

    List<XSSFShape> getShapes(String sheetName) {
        return this.shapeMap.get(sheetName);
    }

    static class StreamingSheetIterator
    implements Iterator<Sheet> {
        private final Iterator<StreamingSheet> iterator;

        public StreamingSheetIterator(Iterator<StreamingSheet> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Sheet next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

