/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel;

import com.dataiku.dss.shadelibpoi.org.apache.logging.log4j.Logger;
import com.dataiku.dss.shadelibpoi.org.apache.poi.logging.PoiLogManager;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.DifferentialStyleProvider;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.TableStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.TableStyleType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.IndexedColorMap;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFDxfStyleProvider;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.XmlCursor;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.XmlException;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.XmlObject;
import com.dataiku.dss.shadelibpoi.org.apache.xmlbeans.XmlOptions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxfs;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableStyleElement;

public class XSSFTableStyle
implements TableStyle {
    private static final Logger LOG = PoiLogManager.getLogger(XSSFTableStyle.class);
    private final String name;
    private final int index;
    private final Map<TableStyleType, DifferentialStyleProvider> elementMap = new EnumMap<TableStyleType, DifferentialStyleProvider>(TableStyleType.class);

    public XSSFTableStyle(int index, CTDxfs dxfs, CTTableStyle tableStyle, IndexedColorMap colorMap) {
        CTDxf dxf;
        this.name = tableStyle.getName();
        this.index = index;
        ArrayList<CTDxf> dxfList = new ArrayList<CTDxf>();
        try (XmlCursor cur = dxfs.newCursor();){
            String xquery = "declare namespace x='http://schemas.openxmlformats.org/spreadsheetml/2006/main' .//x:dxf | .//dxf";
            cur.selectPath(xquery);
            while (cur.toNextSelection()) {
                XmlObject obj = cur.getObject();
                String parentName = obj.getDomNode().getParentNode().getNodeName();
                if (!parentName.equals("mc:Fallback") && !parentName.equals("x:dxfs") && !parentName.contentEquals("dxfs")) continue;
                try {
                    dxf = obj instanceof CTDxf ? (CTDxf)obj : (CTDxf)CTDxf.Factory.parse(obj.newXMLStreamReader(), new XmlOptions().setDocumentType(CTDxf.type));
                    if (dxf == null) continue;
                    dxfList.add(dxf);
                }
                catch (XmlException e) {
                    LOG.atWarn().withThrowable(e).log("Error parsing XSSFTableStyle");
                }
            }
        }
        for (CTTableStyleElement element : tableStyle.getTableStyleElementList()) {
            if (element.getType() == null) {
                throw new IllegalArgumentException("Did not have a type in table-style " + element);
            }
            TableStyleType type = TableStyleType.valueOf(element.getType().toString());
            XSSFDxfStyleProvider dstyle = null;
            if (element.isSetDxfId()) {
                int idx = (int)element.getDxfId();
                dxf = (CTDxf)dxfList.get(idx);
                int stripeSize = 0;
                if (element.isSetSize()) {
                    stripeSize = (int)element.getSize();
                }
                if (dxf != null) {
                    dstyle = new XSSFDxfStyleProvider(dxf, stripeSize, colorMap);
                }
            }
            this.elementMap.put(type, dstyle);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    public DifferentialStyleProvider getStyle(TableStyleType type) {
        return this.elementMap.get((Object)type);
    }
}

