/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dip.shaker.processors.expr.TokenizedText;
import com.dataiku.dip.shaker.processors.transform.TextSimplifierAlgorithm;

public class TextSimplifierUDF
extends SnowflakeUDF {
    private static volatile ThreadLocal<TextSimplifierAlgorithm> algorithm = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String process(String input, boolean normalize, boolean stem, boolean clearStopWords, boolean sortAlphabetically, String language) {
        if (algorithm == null) {
            Class<TextSimplifierUDF> clazz = TextSimplifierUDF.class;
            // MONITORENTER : com.dataiku.dip.shaker.processors.transform.TextSimplifierUDF.class
            if (algorithm == null) {
                algorithm = ThreadLocal.withInitial(() -> {
                    try {
                        TextSimplifierAlgorithm.Parameter params = new TextSimplifierAlgorithm.Parameter();
                        params.normalize = normalize;
                        params.stem = stem;
                        params.clearStopWords = clearStopWords;
                        params.sortAlphabetically = sortAlphabetically;
                        params.language = language;
                        return new TextSimplifierAlgorithm(params);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize TextSimplifierAlgorithm!", e);
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        TokenizedText tokenized = new TokenizedText(input);
        algorithm.get().simplify(tokenized);
        return tokenized.toString(" ");
    }
}

