/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.typespecific;

import com.dataiku.dip.shaker.processors.SnowflakeUDF;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelib.com.google.gson.JsonElement;
import com.dataiku.dss.shadelib.com.google.gson.JsonObject;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class QueryStringSplitterUDF
extends SnowflakeUDF {
    Gson gson = new GsonBuilder().create();

    public static void splitHelper(String str, char separatorChar, boolean preserveAllTokens, List<String> list) {
        list.clear();
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
    }

    public String split(String input, String prefix) {
        if (input == null || input.isEmpty()) {
            return "{}";
        }
        ArrayList<String> chunksBuffer = new ArrayList<String>();
        ArrayList<String> subChunksBuffer = new ArrayList<String>();
        JsonObject ret = new JsonObject();
        try {
            QueryStringSplitterUDF.splitHelper(input, '&', false, chunksBuffer);
            for (String chunk : chunksBuffer) {
                QueryStringSplitterUDF.splitHelper(chunk, '=', false, subChunksBuffer);
                if (subChunksBuffer.size() != 2) continue;
                String key = URLDecoder.decode((String)subChunksBuffer.get(0), "utf8");
                String value = URLDecoder.decode((String)subChunksBuffer.get(1), "utf8");
                String colKey = prefix != null ? prefix + key : key;
                ret.addProperty(colKey, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.gson.toJson((JsonElement)ret);
    }
}

