/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import com.twitter.joauth.OAuthParams;
import com.twitter.joauth.Request;
import com.twitter.joauth.UrlCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class Normalizer {
    static final String HTTP = "HTTP";
    static final String HTTPS = "HTTPS";
    private static final StandardNormalizer STANDARD_NORMALIZER = new StandardNormalizer();

    public static Normalizer getStandardNormalizer() {
        return STANDARD_NORMALIZER;
    }

    public abstract String normalize(String var1, String var2, int var3, String var4, String var5, List<Request.Pair> var6, OAuthParams.OAuth1Params var7);

    public String normalize(Request.ParsedRequest req, OAuthParams.OAuth1Params oAuth1Params) {
        return this.normalize(req.scheme(), req.host(), req.port(), req.verb(), req.path(), req.params(), oAuth1Params);
    }

    public static class StandardNormalizer
    extends Normalizer {
        @Override
        public String normalize(String scheme, String host, int port, String verb, String path, List<Request.Pair> params, OAuthParams.OAuth1Params oAuth1Params) {
            StringBuilder paramsBuilder = new StringBuilder(512);
            ArrayList<Request.Pair> sigParams = new ArrayList<Request.Pair>();
            sigParams.addAll(params);
            sigParams.addAll(oAuth1Params.toList(false));
            Collections.sort(sigParams, new Comparator<Request.Pair>(){

                @Override
                public int compare(Request.Pair thisPair, Request.Pair thatPair) {
                    int keyCompare = thisPair.key.compareTo(thatPair.key);
                    if (keyCompare == 0) {
                        return thisPair.value.compareTo(thatPair.value);
                    }
                    return keyCompare;
                }
            });
            if (!sigParams.isEmpty()) {
                Request.Pair head = (Request.Pair)sigParams.get(0);
                paramsBuilder.append(head.key).append('=').append(head.value);
                for (int i = 1; i < sigParams.size(); ++i) {
                    Request.Pair pair = (Request.Pair)sigParams.get(i);
                    paramsBuilder.append('&').append(pair.key).append('=').append(pair.value);
                }
            }
            StringBuilder requestUrlBuilder = new StringBuilder(512);
            requestUrlBuilder.append(scheme.toLowerCase());
            requestUrlBuilder.append("://");
            requestUrlBuilder.append(host.toLowerCase());
            if (this.includePortString(port, scheme)) {
                requestUrlBuilder.append(":").append(port);
            }
            requestUrlBuilder.append(path);
            StringBuilder normalizedBuilder = new StringBuilder(512);
            normalizedBuilder.append(verb.toUpperCase());
            normalizedBuilder.append('&').append(UrlCodec.encode(requestUrlBuilder.toString()));
            normalizedBuilder.append('&').append(UrlCodec.encode(paramsBuilder.toString()));
            return normalizedBuilder.toString();
        }

        boolean includePortString(int port, String scheme) {
            return !(port == 80 && Normalizer.HTTP.equalsIgnoreCase(scheme) || port == 443 && Normalizer.HTTPS.equalsIgnoreCase(scheme));
        }
    }
}

