/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.custom;

import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.custom.CustomUserAuthenticator;
import com.dataiku.dip.security.custom.CustomUserSupplier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SampleCustomUserAuthenticatorAndSupplier
implements CustomUserAuthenticator,
CustomUserSupplier {
    @Override
    public UserIdentity authenticate(String inputLogin, String password) throws ServerAuthenticationFailure, UserAuthenticationException, UserNotFoundException {
        UserIdentity userIdentity = new UserIdentity(UserSourceType.CUSTOM, inputLogin);
        userIdentity.email = "Get the email from your external user";
        userIdentity.displayName = "Get the display from your external user";
        return userIdentity;
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws ServerAuthenticationFailure, UserNotFoundException {
        UserAttributes userAttributes = new UserAttributes();
        userAttributes.email = "Get the email from your external user";
        userAttributes.displayName = "Get the display from your external user";
        return userAttributes;
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        Set<UserAttributes> users = Collections.emptySet();
        if (filter.getLogin() != null || filter.getGroupName() != null) {
            // empty if block
        }
        return users;
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        HashSet<String> groups = new HashSet<String>();
        return groups;
    }

    @Override
    public boolean canSyncOnDemand() {
        return true;
    }

    @Override
    public boolean canFetchUsers() {
        return true;
    }

    @Override
    public boolean canFetchGroups() {
        return true;
    }
}

