/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.impl;

import com.dataiku.dip.transactions.DebugTransactionRegistry;
import com.dataiku.dip.transactions.TransactionDebugInfo;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.ProxiedReadOnlyFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.impl.StreamTracker;
import com.dataiku.dip.transactions.utils.ReadWriteUpgradableLock;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;

public class TransactionImpl
extends ProxiedReadOnlyFS
implements Transaction {
    private final CachedReadFS cachedReadFS;
    private ReadWriteUpgradableLock.LockHandle lockHandle;
    private final File root;
    private final StreamTracker streamTracker = new StreamTracker(this);
    public final TransactionDebugInfo debugInfo;
    private final DebugTransactionRegistry registry;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.transactions");

    public TransactionImpl(File root, DebugTransactionRegistry registry, CachedReadFS cachedReadFS, ReadWriteUpgradableLock rwLock, TransactionDebugInfo debugInfo) {
        this.debugInfo = debugInfo;
        this.root = root;
        this.registry = registry;
        this.registry.registerRead(this);
        this.cachedReadFS = cachedReadFS;
        this.lockHandle = rwLock.acquireFairReadLock();
        this.debugInfo.state = TransactionProvider.TransactionState.RUNNING;
        this.debugInfo.startedTime = System.currentTimeMillis();
    }

    @Override
    protected synchronized RelFileInputStream wrapFSInputStream(RelFileInputStream stream) {
        return this.streamTracker.track(stream);
    }

    @Override
    protected synchronized <T> T wrapFSAccess(ProxiedReadOnlyFS.WrappedMethodCall<T> r) throws IOException {
        if (!this.isAlive()) {
            throw new RuntimeException("The transaction has been closed");
        }
        return r.call();
    }

    @Override
    protected synchronized ReadOnlyFS getDelegateFS() {
        return this.cachedReadFS;
    }

    @Override
    public synchronized boolean isAlive() {
        return this.lockHandle != null;
    }

    @Override
    public synchronized void close() {
        if (this.lockHandle != null) {
            this.streamTracker.close();
            this.lockHandle.close();
            this.lockHandle = null;
            this.debugInfo.endTime = System.currentTimeMillis();
            this.registry.unregister(this);
        }
    }

    @Override
    public File resolve(RelFile file) {
        return file.resolve(this.root);
    }

    @Override
    public TransactionDebugInfo getDebugInfo() {
        return this.debugInfo;
    }
}

