/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CrudeJSONifiableObjectSizeEstimator {
    private static Iterable<Field> getAllFields(Object o) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = o.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        AccessibleObject.setAccessible(fields.toArray(new AccessibleObject[fields.size()]), true);
        return fields;
    }

    public static String estimateObjectSize(Object o) {
        MemoryEstimationVisitor v = new MemoryEstimationVisitor();
        try {
            CrudeJSONifiableObjectSizeEstimator.exploreObject(o, v);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Failed to estimate object size", e);
        }
        return "primitives=" + v.estimatedPrimitives + " structure=" + v.estimatedStructure;
    }

    public static String dumpObjectStructure(Object o) {
        FullDumpVisitor v = new FullDumpVisitor();
        try {
            CrudeJSONifiableObjectSizeEstimator.exploreObject(o, v);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Failed to estimate object size", e);
        }
        return v.sb.toString();
    }

    private static int primitiveSize(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Long.TYPE) {
            return 8;
        }
        if (clazz == Float.TYPE) {
            return 4;
        }
        if (clazz == Double.TYPE) {
            return 8;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == Boolean.TYPE) {
            return 1;
        }
        return 0;
    }

    private static int stringSize(String s) {
        return s.length() * 2 + 16 + 16;
    }

    private static int listStructureSize(List<?> list) {
        return 20 + 4 * list.size();
    }

    private static int mapStructureSize(Map<?, ?> map) {
        return 32 + 36 * map.size();
    }

    private static void exploreObject(Object obj, ObjectVisitor visitor) throws IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (Map.class.isAssignableFrom(clazz)) {
            Map m = (Map)obj;
            visitor.enterMap(m);
            for (Map.Entry me : m.entrySet()) {
                CrudeJSONifiableObjectSizeEstimator.exploreObject(me.getKey(), visitor);
                CrudeJSONifiableObjectSizeEstimator.exploreObject(me.getValue(), visitor);
            }
            visitor.leaveMap();
        } else if (List.class.isAssignableFrom(clazz)) {
            List l = (List)obj;
            visitor.enterList(l);
            for (Object o : l) {
                CrudeJSONifiableObjectSizeEstimator.exploreObject(o, visitor);
            }
            visitor.leaveList();
        } else if ("java.lang.String".equals(clazz.getName())) {
            visitor.visitString((String)obj);
        } else if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                visitor.visitPrimitiveArray(clazz.getComponentType(), Array.getLength(obj));
            } else {
                visitor.enterArray();
                for (int i = 0; i < Array.getLength(obj); ++i) {
                    CrudeJSONifiableObjectSizeEstimator.exploreObject(Array.get(obj, i), visitor);
                }
                visitor.leaveArray();
            }
        } else {
            visitor.enterObject(obj);
            for (Field field : CrudeJSONifiableObjectSizeEstimator.getAllFields(obj)) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                if (field.getType().isPrimitive()) {
                    visitor.visitPrimitiveField(field, field.get(obj));
                    continue;
                }
                visitor.enterField(field);
                Object child = field.get(obj);
                if (child != null) {
                    CrudeJSONifiableObjectSizeEstimator.exploreObject(child, visitor);
                }
                visitor.leaveField();
            }
            visitor.leaveObject();
        }
    }

    static class MemoryEstimationVisitor
    implements ObjectVisitor {
        int estimatedPrimitives = 0;
        int estimatedStructure = 0;

        MemoryEstimationVisitor() {
        }

        @Override
        public void visitPrimitiveArray(Class<?> elementClass, int length) {
            this.estimatedPrimitives += CrudeJSONifiableObjectSizeEstimator.primitiveSize(elementClass) * length;
        }

        @Override
        public void visitPrimitiveField(Field f, Object value) {
            Class<?> elementClass = f.getType();
            this.estimatedPrimitives += CrudeJSONifiableObjectSizeEstimator.primitiveSize(elementClass);
        }

        @Override
        public void visitString(String s) {
            this.estimatedPrimitives += s.length() * 2;
            this.estimatedStructure += 32;
        }

        @Override
        public void enterObject(Object o) {
            this.estimatedStructure += 16;
        }

        @Override
        public void leaveObject() {
        }

        @Override
        public void enterArray() {
            this.estimatedStructure += 4;
        }

        @Override
        public void leaveArray() {
        }

        @Override
        public void enterMap(Map<?, ?> map) {
            this.estimatedStructure += CrudeJSONifiableObjectSizeEstimator.mapStructureSize(map);
        }

        @Override
        public void leaveMap() {
            this.leaveObject();
        }

        @Override
        public void enterList(List<?> list) {
            this.estimatedStructure += CrudeJSONifiableObjectSizeEstimator.listStructureSize(list);
        }

        @Override
        public void leaveList() {
            this.leaveObject();
        }

        @Override
        public void enterField(Field f) {
            this.estimatedStructure += 4;
        }

        @Override
        public void leaveField() {
        }
    }

    static interface ObjectVisitor {
        public void visitPrimitiveArray(Class<?> var1, int var2);

        public void visitPrimitiveField(Field var1, Object var2);

        public void visitString(String var1);

        public void enterObject(Object var1);

        public void leaveObject();

        public void enterArray();

        public void leaveArray();

        public void enterField(Field var1);

        public void leaveField();

        public void enterMap(Map<?, ?> var1);

        public void leaveMap();

        public void enterList(List<?> var1);

        public void leaveList();
    }

    static class FullDumpVisitor
    implements ObjectVisitor {
        StringBuilder sb = new StringBuilder();
        int depth = 0;
        List<StackElt> stack = new ArrayList<StackElt>();

        FullDumpVisitor() {
        }

        void println(Object x) {
            for (int i = 0; i < this.depth; ++i) {
                this.sb.append("  ");
            }
            this.sb.append(x);
            this.sb.append('\n');
        }

        void addEstimate(int est) {
            for (int i = 0; i < this.stack.size(); ++i) {
                if (this.stack.get((int)i).type == StackEltType.FIELD) continue;
                this.stack.get((int)i).deep += est;
                if (i != this.stack.size() - 1) continue;
                this.stack.get((int)i).self += est;
            }
        }

        @Override
        public void visitPrimitiveArray(Class<?> elementClass, int length) {
            this.println("PrimitiveArray type=" + elementClass.getTypeName() + " len=" + length);
            this.addEstimate(CrudeJSONifiableObjectSizeEstimator.primitiveSize(elementClass) * length);
        }

        @Override
        public void visitString(String s) {
            this.println("String len=" + s.length());
            this.addEstimate(CrudeJSONifiableObjectSizeEstimator.stringSize(s));
        }

        @Override
        public void visitPrimitiveField(Field f, Object value) {
            this.println("PrimitiveField name=" + f.getName() + " type=" + String.valueOf(f.getType()));
            this.addEstimate(CrudeJSONifiableObjectSizeEstimator.primitiveSize(f.getType()));
        }

        @Override
        public void enterMap(Map<?, ?> map) {
            this.println("Map");
            this.stack.add(new StackElt(StackEltType.OBJECT));
            ++this.depth;
            this.addEstimate(CrudeJSONifiableObjectSizeEstimator.mapStructureSize(map));
        }

        @Override
        public void leaveMap() {
            this.leaveObject();
        }

        @Override
        public void enterList(List<?> list) {
            this.println("List");
            this.stack.add(new StackElt(StackEltType.OBJECT));
            ++this.depth;
            this.addEstimate(CrudeJSONifiableObjectSizeEstimator.listStructureSize(list));
        }

        @Override
        public void leaveList() {
            this.leaveObject();
        }

        @Override
        public void enterObject(Object o) {
            if (o instanceof JsonElement) {
                this.println("JsonElement " + JSON.json((Object)o));
            } else {
                this.println("Object ofClazz=" + String.valueOf(o.getClass()));
            }
            this.stack.add(new StackElt(StackEltType.OBJECT));
            ++this.depth;
            this.addEstimate(16);
        }

        @Override
        public void leaveObject() {
            --this.depth;
            this.println("EndObject self=" + this.stack.get((int)(this.stack.size() - 1)).self + " deep=" + this.stack.get((int)(this.stack.size() - 1)).deep);
            this.stack.remove(this.stack.size() - 1);
        }

        @Override
        public void enterArray() {
            this.addEstimate(4);
            this.println("Array");
            this.stack.add(new StackElt(StackEltType.ARRAY));
            ++this.depth;
        }

        @Override
        public void leaveArray() {
            --this.depth;
            this.println("EndArray self=" + this.stack.get((int)(this.stack.size() - 1)).self + " deep=" + this.stack.get((int)(this.stack.size() - 1)).deep);
            this.stack.remove(this.stack.size() - 1);
        }

        @Override
        public void enterField(Field f) {
            this.addEstimate(4);
            this.println("Field name=" + f.getName() + " ofType=" + String.valueOf(f.getType()));
            this.stack.add(new StackElt(StackEltType.FIELD));
            ++this.depth;
        }

        @Override
        public void leaveField() {
            this.stack.remove(this.stack.size() - 1);
            --this.depth;
        }

        static class StackElt {
            StackEltType type;
            int self = 0;
            int deep = 0;

            StackElt(StackEltType type) {
                this.type = type;
            }
        }

        static enum StackEltType {
            FIELD,
            OBJECT,
            ARRAY;

        }
    }
}

