/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.AutoCloseableLock;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NamedRWLock
extends ReentrantReadWriteLock {
    private static final long serialVersionUID = 1L;
    private int lockCounter = 0;
    private static final Map<String, NamedRWLock> index = new HashMap<String, NamedRWLock>();

    private NamedRWLock() {
    }

    private RWLockInfo dumpInfo() {
        return new RWLockInfo(this.getOwner(), this.getReadLockCount(), this.getQueueLength());
    }

    private static synchronized NamedRWLock incrementCounter(String name) {
        NamedRWLock lock = index.computeIfAbsent(name, n -> new NamedRWLock());
        ++lock.lockCounter;
        return lock;
    }

    private static synchronized void decrementCounter(String name) {
        NamedRWLock lock = index.get(name);
        if (lock == null) {
            throw new IllegalStateException(String.format("RW lock (%s) is no longer in the index", name));
        }
        if (lock.lockCounter <= 0) {
            throw new IllegalStateException(String.format("RW lock (%s) counter is too low: %d", name, lock.lockCounter));
        }
        --lock.lockCounter;
        if (lock.lockCounter == 0) {
            index.remove(name);
        }
    }

    public static synchronized Map<String, RWLockInfo> dumpAcquiredLocksInfo() {
        HashMap<String, RWLockInfo> infoByName = new HashMap<String, RWLockInfo>();
        index.forEach((name, lock) -> infoByName.put((String)name, lock.dumpInfo()));
        return infoByName;
    }

    public static AutoCloseableLock acquireRead(String name) {
        NamedRWLock lock = NamedRWLock.incrementCounter(name);
        lock.readLock().lock();
        return new ReadLockHandle(name, true);
    }

    public static AutoCloseableLock acquireWrite(String name) {
        NamedRWLock lock = NamedRWLock.incrementCounter(name);
        lock.writeLock().lock();
        return new WriteLockHandle(name, true);
    }

    public static WriteLockHandle tryAcquireWrite(String name) {
        NamedRWLock lock = NamedRWLock.incrementCounter(name);
        boolean isAcquired = lock.writeLock().tryLock();
        return new WriteLockHandle(name, isAcquired);
    }

    public static class RWLockInfo {
        public final Thread owner;
        public final int readLockCount;
        public final int queueLength;

        public RWLockInfo(Thread owner, int readLockCount, int queueLength) {
            this.owner = owner;
            this.readLockCount = readLockCount;
            this.queueLength = queueLength;
        }
    }

    public static class ReadLockHandle
    extends AbstractLockHandle {
        private ReadLockHandle(String name, boolean isAcquired) {
            super(name, isAcquired);
        }

        @Override
        protected void unlock(NamedRWLock lock) {
            lock.readLock().unlock();
        }
    }

    public static class WriteLockHandle
    extends AbstractLockHandle {
        private WriteLockHandle(String name, boolean isAcquired) {
            super(name, isAcquired);
        }

        @Override
        protected void unlock(NamedRWLock lock) {
            lock.writeLock().unlock();
        }
    }

    private static abstract class AbstractLockHandle
    implements AutoCloseableLock {
        private final String name;
        private final boolean isAcquired;

        private AbstractLockHandle(String name, boolean isAcquired) {
            this.name = name;
            this.isAcquired = isAcquired;
        }

        public boolean isAcquired() {
            return this.isAcquired;
        }

        @Override
        public void close() {
            NamedRWLock lock = NamedRWLock.incrementCounter(this.name);
            try {
                if (this.isAcquired) {
                    this.unlock(lock);
                }
                NamedRWLock.decrementCounter(this.name);
            }
            finally {
                NamedRWLock.decrementCounter(this.name);
            }
        }

        protected abstract void unlock(NamedRWLock var1);
    }
}

