/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling.encoding;

import io.trino.jdbc.$internal.airlift.compress.zstd.ZstdDecompressor;
import io.trino.jdbc.$internal.client.QueryDataDecoder;
import io.trino.jdbc.$internal.client.spooling.encoding.CompressedQueryDataDecoder;
import java.io.IOException;

public class ZstdQueryDataDecoder
extends CompressedQueryDataDecoder {
    public ZstdQueryDataDecoder(QueryDataDecoder delegate) {
        super(delegate);
    }

    @Override
    void decompress(byte[] bytes, byte[] output) throws IOException {
        ZstdDecompressor decompressor = new ZstdDecompressor();
        int decompressedSize = decompressor.decompress(bytes, 0, bytes.length, output, 0, output.length);
        if (decompressedSize != output.length) {
            throw new IOException(String.format("Decompressed size does not match expected segment size, expected %d, got %d", decompressedSize, output.length));
        }
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+zstd";
    }
}

