/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive.shims;

import com.dataiku.dip.input.formats.hive.serde.DSSInspectionException;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaDateObjectInspector;

public class Hive3DSSDateObjectInspector
extends JavaDateObjectInspector
implements DSSBaseInspector {
    private static final DateTimeFormatter isoParser = ISODateTimeFormat.dateParser().withZone(DateTimeZone.UTC);
    private DSSBaseInspector parent;

    public DSSBaseInspector getParent() {
        return this.parent;
    }

    public void setParent(DSSBaseInspector parent) {
        this.parent = parent;
    }

    public DateWritableV2 getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DateWritableV2(Hive3DSSDateObjectInspector.asDateInternal(this, o));
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : Hive3DSSDateObjectInspector.asDateInternal(this, o);
    }

    static Date asDateInternal(DSSBaseInspector asAnotherInspector, Object o) {
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            try {
                LocalDate dt = isoParser.parseLocalDate((String)o);
                return Date.of((int)dt.getYear(), (int)dt.getMonthOfYear(), (int)dt.getDayOfMonth());
            }
            catch (IllegalArgumentException e) {
                RuntimeException enhancedException = new RuntimeException("Failed to parse DSS date only. " + e.getMessage(), e);
                throw new DSSInspectionException(asAnotherInspector, (Throwable)enhancedException);
            }
        }
        if (o == null) {
            throw new DSSInspectionException(asAnotherInspector, "Cannot be null here", null);
        }
        throw new RuntimeException("Unsupported convertion from " + o.getClass().getSimpleName() + " to Timestamp, should be a DSS date only", null);
    }
}

