/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.PrettyString;

public class IndentedWriter {
    private int startIndex;
    private String separator = " ";
    private String indentString = " ";
    private String textIndentSeparator = "";
    private int firstLineIndentSize = 2;
    private int indentSize = 2;
    private int termSize = 80;

    public void print(String command, String msg) {
    }

    public void print(String message) {
        boolean hasPrint = false;
        int index = this.startIndex;
        StringBuilder sb = new StringBuilder();
        index += this.indent(sb, this.firstLineIndentSize);
        for (String word : message.split(" ")) {
            if (index + word.length() >= this.termSize && hasPrint) {
                sb.append(PrettyString.eol());
                index = this.indent(sb, this.indentSize);
                sb.append(word);
            } else {
                if (hasPrint) {
                    sb.append(this.separator);
                }
                hasPrint = true;
                sb.append(word);
            }
            index += word.length() + this.separator.length();
        }
        System.out.print(sb.toString());
        if (index != 0) {
            System.out.println();
        }
        System.out.flush();
    }

    public void paragraph(String ... messages) {
        boolean nl = false;
        for (String msg : messages) {
            if (nl) {
                System.err.println();
            } else {
                nl = true;
            }
            this.print(msg);
        }
    }

    public int getFirstLineIndentSize() {
        return this.firstLineIndentSize;
    }

    public void setFirstLineIndentsize(int firstLineIndentSize) {
        this.firstLineIndentSize = firstLineIndentSize;
    }

    public IndentedWriter withFirstLineIndentsize(int firstLineIndentSize) {
        this.setFirstLineIndentsize(firstLineIndentSize);
        return this;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public IndentedWriter withIndentSize(int indentSize) {
        this.setIndentSize(indentSize);
        return this;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public String getTextIndentSeparator() {
        return this.textIndentSeparator;
    }

    public void setTextIndentSeparator(String textIndentSeparator) {
        this.textIndentSeparator = textIndentSeparator;
    }

    public int getTermSize() {
        return this.termSize;
    }

    public void setTermSize(int termSize) {
        this.termSize = termSize;
    }

    public IndentedWriter withTermSize(int termSize) {
        this.setTermSize(termSize);
        return this;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public IndentedWriter withStartIndex(int startIndex) {
        this.setStartIndex(startIndex);
        return this;
    }

    private int indent(StringBuilder sb, int indentSize) {
        for (int i = 0; i < indentSize; ++i) {
            sb.append(this.indentString);
        }
        sb.append(this.textIndentSeparator);
        return indentSize * this.indentString.length() + this.textIndentSeparator.length();
    }
}

