/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.oauth;

import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.jdbc.common.OAuthSettings;
import com.databricks.client.jdbc.common.SSLSettings;
import com.databricks.client.jdbc.core.DSDriver;
import com.databricks.client.jdbc.exceptions.CommonJDBCMessageKey;
import com.databricks.client.jdbc.oauth.OAuthUtil;
import com.databricks.client.jdbc.oauth.OauthProvider;
import com.databricks.client.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.databricks.client.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.databricks.client.jdbc42.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.databricks.client.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.databricks.client.jdbc42.internal.apache.http.message.BasicNameValuePair;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.net.URI;
import java.util.ArrayList;

public class ClientCredentialOAuthProvider
extends OauthProvider {
    private final String CLIENT_ASSERTION_TYPE_KEY = "client_assertion_type";
    private final String CLIENT_ASSERTION_KEY = "client_assertion";
    private final String CLIENT_CRED_GRANT = "client_credentials";

    public ClientCredentialOAuthProvider(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void obtainAccessToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (this.hasValidDatabricksToken()) {
                return;
            }
            if (!this.m_settings.m_enableTestOverrideAuthorizationUrl.booleanValue()) {
                this.m_settings.m_oAuthSettings.m_authorizationUrl = this.m_settings.m_oAuthSettings.m_Oauth2TokenEndpoint;
            }
            this.m_settings.m_oAuthSettings.m_accessToken = this.clientCredentialOAuth();
            this.decodeAndExchangeAccessToken(this.m_oAuthSettings.m_enableMandatoryTokenExchange);
            this.addCustomOAuthHeader("Authorization", "Bearer " + this.m_oAuthSettings.m_accessToken);
        }
        catch (ErrorException errorException) {
            String string = this.getDetailedErrorExceptionMessage(errorException);
            TException tException = new TException(string, errorException.getCause());
            throw tException;
        }
    }

    private HttpPost setRequestParams(HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        arrayList.add(new BasicNameValuePair("grant_type", "client_credentials"));
        if (this.m_oAuthSettings.m_OAuthUseJWTAssertion.booleanValue()) {
            arrayList.add(new BasicNameValuePair("client_id", this.m_oAuthSettings.m_authClientID));
            arrayList.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            arrayList.add(new BasicNameValuePair("client_assertion", this.m_oAuthSettings.m_OAuthClientAssertion));
        } else if (this.m_oAuthSettings.m_authSource == OAuthSettings.OAuthSource.AZURE) {
            arrayList.add(new BasicNameValuePair("client_id", this.m_oAuthSettings.m_authClientID));
            arrayList.add(new BasicNameValuePair("client_secret", this.m_oAuthSettings.m_authClientSecret));
        } else if (this.m_oAuthSettings.m_authSource == OAuthSettings.OAuthSource.AWS) {
            httpPost.addHeader("Authorization", "Basic " + new String(Base64.encodeBase64((this.m_oAuthSettings.m_authClientID + ":" + this.m_oAuthSettings.m_authClientSecret).getBytes())));
        }
        if (null != this.m_oAuthSettings.m_authScope) {
            arrayList.add(new BasicNameValuePair("scope", this.m_oAuthSettings.m_authScope));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, "UTF-8"));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }

    private String clientCredentialOAuth() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        SSLSettings sSLSettings = this.m_settings.m_oAuthSettings.m_tokenEndpointSSLSettings;
        URI uRI = OAuthUtil.getServerURI(this.m_oAuthSettings.m_authorizationUrl, this.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange);
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = this.setRequestParams(httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        string = this.executeRequestWithRetry(uRI, httpPost);
        String string2 = OAuthUtil.parseJsonResponse(string.toString(), "access_token");
        OAuthUtil.setExpiryTime(string, this.m_oAuthSettings, this.m_logger);
        if (null == string2) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        return string2;
    }
}

