/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.fasterxml.jackson.datatype.jsr310.deser;

import com.databricks.client.jdbc42.internal.fasterxml.jackson.annotation.JsonFormat;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonParser;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.core.JsonToken;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.DeserializationContext;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.databind.DeserializationFeature;
import com.databricks.client.jdbc42.internal.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthDeserializer
extends JSR310DateTimeDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;
    public static final YearMonthDeserializer INSTANCE = new YearMonthDeserializer();

    public YearMonthDeserializer() {
        this(DateTimeFormatter.ofPattern("u-MM"));
    }

    public YearMonthDeserializer(DateTimeFormatter formatter) {
        super(YearMonth.class, formatter);
    }

    protected YearMonthDeserializer(YearMonthDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    public YearMonthDeserializer(YearMonthDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    protected YearMonthDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearMonthDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    protected YearMonthDeserializer withLeniency(Boolean leniency) {
        return new YearMonthDeserializer(this, leniency);
    }

    @Override
    public YearMonth deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(parser, context, parser.getText());
        }
        if (parser.isExpectedStartObjectToken()) {
            return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
        }
        if (parser.isExpectedStartArrayToken()) {
            JsonToken t = parser.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                YearMonth parsed = this.deserialize(parser, context);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser, context);
                }
                return parsed;
            }
            if (t != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(context, JsonToken.VALUE_NUMBER_INT, "years");
            }
            int year = parser.getIntValue();
            int month = parser.nextIntValue(-1);
            if (month == -1) {
                if (!parser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                    this._reportWrongToken(context, JsonToken.VALUE_NUMBER_INT, "months");
                }
                month = parser.getIntValue();
            }
            if (parser.nextToken() != JsonToken.END_ARRAY) {
                throw context.wrongTokenException(parser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
            }
            return YearMonth.of(year, month);
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (YearMonth)parser.getEmbeddedObject();
        }
        return (YearMonth)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected YearMonth _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (YearMonth)this._fromEmptyString(p, ctxt, string);
        }
        try {
            return YearMonth.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (YearMonth)this._handleDateTimeException(ctxt, e, string);
        }
    }
}

