/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.functor.arithmetic;

import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class DateTimeFunctorUtil {
    public static final BigInteger DATE_ADD_BIGINT_UPPER_LIMIT = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger DATE_ADD_BIGINT_LOWER_LIMIT = BigInteger.valueOf(Integer.MIN_VALUE);

    DateTimeFunctorUtil() {
    }

    public static Timestamp timestampPlusNum(Timestamp timestamp, long l) throws ErrorException {
        long l2 = timestamp.getTime();
        int n = timestamp.getNanos() % 1000000;
        long l3 = l + l2;
        if ((l & l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL) | (l ^ 0xFFFFFFFFFFFFFFFFL) & (l2 ^ 0xFFFFFFFFFFFFFFFFL) & l3) < 0L) {
            throw SQLEngineExceptionFactory.datetimeArithOverflowException();
        }
        Timestamp timestamp2 = new Timestamp(l3);
        timestamp2.setNanos(timestamp2.getNanos() + n);
        return timestamp2;
    }

    public static Timestamp timestampPlusBigint(Timestamp timestamp, BigInteger bigInteger) throws ErrorException {
        long l = bigInteger.longValue();
        if (bigInteger.compareTo(BigInteger.valueOf(l)) != 0) {
            throw SQLEngineExceptionFactory.datetimeArithOverflowException();
        }
        return DateTimeFunctorUtil.timestampPlusNum(timestamp, l);
    }

    public static Date datePlusNum(Date date, long l) throws ErrorException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            throw SQLEngineExceptionFactory.datetimeArithOverflowException();
        }
        calendar.add(5, (int)l);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date datePlusBigInteger(Date date, BigInteger bigInteger) throws ErrorException {
        if (bigInteger.compareTo(DATE_ADD_BIGINT_LOWER_LIMIT) < 0 || bigInteger.compareTo(DATE_ADD_BIGINT_UPPER_LIMIT) > 0) {
            throw SQLEngineExceptionFactory.datetimeArithOverflowException();
        }
        return DateTimeFunctorUtil.datePlusNum(date, bigInteger.longValue());
    }

    public static Date negateDate(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(date.getTime());
        if (1 == gregorianCalendar.get(0)) {
            gregorianCalendar.set(0, 0);
        } else {
            gregorianCalendar.set(0, 1);
        }
        return new Date(gregorianCalendar.getTimeInMillis());
    }

    public static Timestamp negateTimestamp(Timestamp timestamp) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        if (1 == gregorianCalendar.get(0)) {
            gregorianCalendar.set(0, 0);
        } else {
            gregorianCalendar.set(0, 1);
        }
        Timestamp timestamp2 = new Timestamp(gregorianCalendar.getTimeInMillis());
        timestamp2.setNanos(timestamp.getNanos());
        return timestamp2;
    }
}

