/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import java.util.Objects;
import java.util.Optional;

public class TDClientException
extends RuntimeException {
    private final ErrorType errorType;
    private final Optional<Exception> rootCause;

    private static final String formatErrorMessage(ErrorType errorType, String message, Optional<Exception> cause) {
        String rootCauseErrorMessage = cause.isPresent() ? " The root cause: " + cause.get().getMessage() : "";
        return String.format("[%s] %s%s", errorType.name(), message != null ? message : "", rootCauseErrorMessage);
    }

    public TDClientException(ErrorType errorType, String message, Optional<Exception> cause) {
        super(TDClientException.formatErrorMessage(errorType, message, cause), cause.orElse(null));
        this.errorType = Objects.requireNonNull(errorType, "errorType is null");
        this.rootCause = Objects.requireNonNull(cause, "cause is null");
    }

    public TDClientException(ErrorType errorType, String message, Exception cause) {
        this(errorType, message, Optional.of(cause));
    }

    public TDClientException(ErrorType errorType, Exception cause) {
        this(errorType, cause.getMessage(), Optional.of(cause));
    }

    public TDClientException(ErrorType errorType, String message) {
        this(errorType, message, Optional.empty());
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<Exception> getRootCause() {
        return this.rootCause;
    }

    public static enum ErrorType {
        INVALID_CONFIGURATION,
        INVALID_INPUT,
        AUTHENTICATION_FAILURE,
        TARGET_NOT_FOUND,
        TARGET_ALREADY_EXISTS,
        SERVER_ERROR,
        CLIENT_ERROR,
        PROXY_AUTHENTICATION_FAILURE,
        INTERRUPTED,
        REQUEST_TIMEOUT,
        SSL_ERROR,
        EXECUTION_FAILURE,
        UNEXPECTED_RESPONSE_CODE,
        INVALID_JSON_RESPONSE,
        SOCKET_ERROR;

    }
}

