/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.filter.CompareFilterImpl;
import org.geotools.util.Converters;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.expression.Expression;

public class IsBetweenImpl
extends CompareFilterImpl
implements PropertyIsBetween {
    private Expression expression;
    protected MultiValuedFilter.MatchAction matchAction;

    protected IsBetweenImpl(Expression lower, Expression expression, Expression upper, MultiValuedFilter.MatchAction matchAction) {
        super(lower, upper);
        this.expression = expression;
        this.matchAction = matchAction;
    }

    protected IsBetweenImpl(Expression lower, Expression expression, Expression upper) {
        this(lower, expression, upper, MultiValuedFilter.MatchAction.ANY);
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return this.matchAction;
    }

    public boolean evaluate(Object feature) {
        Object object0 = this.eval(this.expression, feature);
        Object object1 = this.eval(this.expression1, feature);
        Object object2 = this.eval(this.expression2, feature);
        if (object0 == null) {
            return false;
        }
        if (!(object0 instanceof Collection || object1 instanceof Collection || object2 instanceof Collection)) {
            return this.evaluateInternal(object0, object1, object2);
        }
        List<Object> oValues = object0 instanceof Collection ? (List<Object>)object0 : Collections.singletonList(object0);
        List<Object> leftValues = object1 instanceof Collection ? (List<Object>)object1 : Collections.singletonList(object1);
        List<Object> rightValues = object2 instanceof Collection ? (List<Object>)object2 : Collections.singletonList(object2);
        int count = 0;
        for (Object e : leftValues) {
            for (Object e2 : rightValues) {
                for (Object e3 : oValues) {
                    boolean temp = this.evaluateInternal(e3, e, e2);
                    if (temp) {
                        ++count;
                    }
                    switch (this.matchAction) {
                        case ONE: {
                            if (count <= 1) break;
                            return false;
                        }
                        case ALL: {
                            if (temp) break;
                            return false;
                        }
                        case ANY: {
                            if (!temp) break;
                            return true;
                        }
                    }
                }
            }
        }
        switch (this.matchAction) {
            case ONE: {
                return count == 1;
            }
            case ALL: {
                return true;
            }
            case ANY: {
                return false;
            }
        }
        return false;
    }

    public boolean evaluateInternal(Object value, Object lower, Object upper) {
        Object o = value;
        if (o == null) {
            return false;
        }
        Object l = Converters.convert((Object)lower, o.getClass());
        Object u = Converters.convert((Object)upper, o.getClass());
        if (l == null || u == null) {
            l = lower;
            o = Converters.convert((Object)value, l.getClass());
            u = Converters.convert((Object)upper, l.getClass());
            if (o == null || u == null) {
                u = upper;
                o = Converters.convert((Object)value, u.getClass());
                l = Converters.convert((Object)lower, u.getClass());
                if (o == null || l == null) {
                    return false;
                }
            }
        }
        return this.betweenCompare(o, l, u);
    }

    private boolean betweenCompare(Object ojbect, Object low, Object up) {
        Comparable lc = this.comparable(low);
        Comparable uc = this.comparable(up);
        return lc.compareTo(ojbect) <= 0 && uc.compareTo(ojbect) >= 0;
    }

    @Override
    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((PropertyIsBetween)this, extraData);
    }

    public Expression getLowerBoundary() {
        return this.getExpression1();
    }

    public void setLowerBoundary(Expression lowerBoundary) {
        this.setExpression1(lowerBoundary);
    }

    public Expression getUpperBoundary() {
        return this.getExpression2();
    }

    public void setUpperBoundary(Expression upperBoundary) {
        this.setExpression2(upperBoundary);
    }

    @Override
    public String toString() {
        return "[ " + this.expression + " BETWEEN " + this.expression1 + " AND " + this.expression2 + " ]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.matchAction == null ? 0 : this.matchAction.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IsBetweenImpl other = (IsBetweenImpl)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        return this.matchAction == other.matchAction;
    }
}

