/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.StreamingConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/streamingendpoints"})
public class PublicAPIStreamingEndpointsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private StreamingEndpointService streamingEndpointService;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private AuditTrailService auditTrailService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.streamingendpoints");

    @AuditedCall(value={"msgType", "streamingendpoint-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listJobs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List ret = this.streamingEndpointsDAO.list(projectKey);
            PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "streamingendpoint-get", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId:.+}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointsDAO.getMandatoryUnsafe(projectKey, streamingEndpointId));
        }
    }

    @AuditedCall(value={"msgType", "streamingendpoint-delete", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId:.+}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        String commitMessage = "Deleted streaming endpoint " + projectKey + "." + streamingEndpointId;
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.streamingEndpointService.performDeletion(authCtx, projectKey, streamingEndpointId, null);
            this.flowGraphService.invalidateCache(projectKey);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-read-schema", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId}/schema"}, method={RequestMethod.GET})
    public void getSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        StreamingEndpoint se;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
        }
        PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)se.schema);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-save-schema", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId}/schema"}, method={RequestMethod.PUT})
    public void setSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        String message;
        Schema schema = (Schema)this.getRequestBodyAs(req, Schema.class);
        this.require(schema.getColumns() != null, "The columns[] array is mandatory");
        for (SchemaColumn col : schema.getColumns()) {
            this.require(col.getName() != null, "column name is missing");
            this.require(col.getType() != null, "column type is missing or invalid");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            schema.userModified = true;
            se.schema = schema;
            this.streamingEndpointService.save((RWTransactionRef)t, projectKey, se, false);
            message = "Saved streaming endpoint schema for " + se.getFullId();
            t.commit(message);
        }
        PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)message);
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void add(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        JsonObject seObject = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        this.require(seObject.has("id") && StringUtils.isNotBlank((String)seObject.get("id").getAsString()), "Required field 'id' is missing.");
        this.require(seObject.has("type") && StringUtils.isNotBlank((String)seObject.get("type").getAsString()), "Required field 'type' is missing.");
        if (seObject.has("projectKey") && !seObject.get("projectKey").isJsonNull() && seObject.get("projectKey").getAsString().length() > 0) {
            this.require(seObject.get("projectKey").getAsString().equals(projectKey), "Streaming endpoint projectKey does not match the requested URL");
        } else {
            seObject.addProperty("projectKey", projectKey);
        }
        this.require(seObject.has("params") && !seObject.get("params").isJsonNull(), "Required field 'params' is missing.");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        StreamingEndpoint se = (StreamingEndpoint)JSON.parse((JsonElement)seObject, StreamingEndpoint.class);
        String commitMessage = "Created streaming endpoint " + se.id + " in " + se.projectKey;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.streamingEndpointService.create_T(authCtx, projectKey, se);
            t.commit(commitMessage);
        }
        this.auditTrailService.generic("streamingendpoint-create").with("projectKey", se.projectKey).with("streamingEndpointId", se.id).with("type", se.type).emit();
        PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)new PublicAPIControllerBase.ResponseMessageWithId(se.id, commitMessage));
    }

    @AuditInline
    @RequestMapping(value={"/managed"}, method={RequestMethod.POST})
    public void addManaged(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        ManagedStreamingEndpointCreation creation = (ManagedStreamingEndpointCreation)this.getRequestBodyAs(req, ManagedStreamingEndpointCreation.class);
        this.require(StringUtils.isNotBlank((String)creation.id), "Required field 'id' is missing.");
        this.require(StringUtils.isNotBlank((String)creation.creationSettings.connectionId), "Required field 'creationSettings.connectionId' is missing.");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            DSSConnection c = this.connectionsDAO.getMandatoryConnection(authCtx, creation.creationSettings.connectionId);
            if (!(c instanceof StreamingConnection)) {
                throw new IllegalArgumentException("Invalid connection type for streaming endpoints : " + c.getType());
            }
        }
        String commitMessage = "Created streaming endpoint " + creation.id + " in " + projectKey;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.streamingEndpointService.create_T(authCtx, projectKey, creation.id, creation.creationSettings);
            t.commit(commitMessage);
        }
        this.auditTrailService.generic("streamingendpoint-create").with("projectKey", projectKey).with("streamingEndpointId", creation.id).emit();
        PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)new PublicAPIControllerBase.ResponseMessageWithId(creation.id, commitMessage));
    }

    @AuditedCall(value={"msgType", "streamingendpoint-modify", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId:.+}"}, method={RequestMethod.PUT})
    public void modify(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        StreamingEndpoint se = (StreamingEndpoint)this.getRequestBodyAs(req, StreamingEndpoint.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        String commitMessage = "Modify streaming endpoint " + projectKey + "." + streamingEndpointId;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            StreamingEndpoint oldSe = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            if (se.getParams() == null) {
                se.setParams(oldSe.getParams());
            }
            this.streamingEndpointService.save((RWTransactionRef)t, projectKey, se, false);
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "streamingendpoint-test", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId}/actions/testAndDetectSettings/kafka"}, method={RequestMethod.POST})
    public void testKafka(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        StreamingEndpointTestSettings settings = (StreamingEndpointTestSettings)this.getRequestBodyAs(req, StreamingEndpointTestSettings.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            if (!"kafka".equals(se.type)) {
                throw new IllegalArgumentException("Streaming endpoint is not a kafka endpoint (" + se.type + ")");
            }
            PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.collectSample(authCtx, se, settings.limit, settings.timeout * 1000, settings.inferStorageTypes));
        }
    }

    @AuditedCall(value={"msgType", "streamingendpoint-test", "projectKey", "${projectKey}", "streamingEndpointId", "${streamingEndpointId}"})
    @RequestMapping(value={"/{streamingEndpointId}/actions/testAndDetectSettings/httpsse"}, method={RequestMethod.POST})
    public void testHttpSSE(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String streamingEndpointId) throws Exception {
        StreamingEndpointTestSettings settings = (StreamingEndpointTestSettings)this.getRequestBodyAs(req, StreamingEndpointTestSettings.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(projectKey, streamingEndpointId);
            if (!"httpsse".equals(se.type)) {
                throw new IllegalArgumentException("Streaming endpoint is not a HTTP SSE endpoint (" + se.type + ")");
            }
            PublicAPIStreamingEndpointsController.writeJSON((HttpServletResponse)resp, (Object)this.streamingEndpointService.collectSample(authCtx, se, settings.limit, settings.timeout * 1000, settings.inferStorageTypes));
        }
    }

    private static class ManagedStreamingEndpointCreation {
        public String id;
        public StreamingEndpointService.StreamingEndpointCreationSettings creationSettings = new StreamingEndpointService.StreamingEndpointCreationSettings();

        private ManagedStreamingEndpointCreation() {
        }
    }

    public static class StreamingEndpointTestSettings {
        public boolean inferStorageTypes;
        public int limit = 10;
        public int timeout = 60;
    }
}

