/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JF;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/bundles"})
public class PublicAPIBundlesCreationController
extends PublicAPIControllerBase {
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "automation-bundles-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/imported"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        PublicAPIBundlesCreationController.writeJSON((HttpServletResponse)resp, (Object)this.automationBundlesService.listImported(projectKey));
    }

    @AuditInline
    @RequestMapping(value={"/imported/actions/importFromArchive"}, method={RequestMethod.POST})
    public void importFromArchive(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String archivePath, @RequestParam(required=false, defaultValue="false") boolean allowProjectKeyMismatch) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        String bundleId = this.automationBundlesService.importBundleArchive(authCtx, projectKey, new File(archivePath), true, allowProjectKeyMismatch);
        PublicAPIBundlesCreationController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("projectKey", projectKey).with("bundleId", bundleId).get());
        this.auditTrailService.generic("automation-bundle-import").with("projectKey", projectKey).with("bundleId", bundleId).emit();
    }

    @AuditInline
    @RequestMapping(value={"/imported/actions/importFromStream"}, method={RequestMethod.POST})
    public void importFromStream(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file") MultipartFile filePart, @RequestParam(required=false, defaultValue="false") boolean allowProjectKeyMismatch) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        String bundleId = this.automationBundlesService.importBundleZipStream(authCtx, projectKey, filePart.getInputStream(), allowProjectKeyMismatch);
        PublicAPIBundlesCreationController.writeJSON((HttpServletResponse)resp, (Object)JF.obj().with("projectKey", projectKey).with("bundleId", bundleId).get());
        this.auditTrailService.generic("automation-bundle-import").with("projectKey", projectKey).with("bundleId", bundleId).emit();
    }

    @AuditedCall(value={"msgType", "automation-bundle-activate", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/imported/{bundleId}/actions/activate"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<BundleActivator.BundleActivationReport> activateBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId, @RequestBody(required=false) AbstractBundleService.BundleActivationOptions activationOptions) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        if (activationOptions == null) {
            activationOptions = new AbstractBundleService.BundleActivationOptions();
        }
        FutureResponse fr = this.automationBundlesService.startActivateBundle_NT(authCtx, projectKey, bundleId, activationOptions);
        if (activationOptions.async) {
            return fr;
        }
        return this.futureService.waitForFinalResponse(fr);
    }

    @AuditedCall(value={"msgType", "automation-bundle-preload", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/imported/{bundleId}/actions/preload"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<BundlePreloader.BundlePreloadingReport> preloadBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId, @RequestBody(required=false) AbstractBundleService.BundlePreloadOptions preloadOptions) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        if (preloadOptions == null) {
            preloadOptions = new AbstractBundleService.BundlePreloadOptions();
        }
        FutureResponse fr = this.automationBundlesService.startPreloadBundle_NT(authCtx, projectKey, bundleId);
        if (preloadOptions.async) {
            return fr;
        }
        return this.futureService.waitForFinalResponse(fr);
    }

    @AuditedCall(value={"msgType", "automation-bundle-activate-check", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/imported/{bundleId}/actions/activate-check"}, method={RequestMethod.GET})
    public void checkBundleActivation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        PublicAPIBundlesCreationController.writeJSON((HttpServletResponse)resp, (Object)this.automationBundlesService.checkBundleActivation(authCtx, projectKey, bundleId, false));
    }

    @AuditedCall(value={"msgType", "automation-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/imported/{bundleId}"}, method={RequestMethod.DELETE})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String bundleId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        this.automationBundlesService.deleteBundle(projectKey, bundleId);
        this.writeMessage(resp, "Deleted bundle " + bundleId, new Object[0]);
    }
}

