/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.docportal.PythonDocPortalService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.docportal.PythonDocPortalSearchService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PythonDocPortalController
extends DIPInternalControllerBase {
    @Autowired
    PythonDocPortalService pythonDocPortalService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    private PythonDocPortalSearchService pythonDocPortalSearchService;

    @AuditedCall(value={"msgType", "docportal-get"})
    @RequestMapping(value={"/api/docportal/get-package-doc"})
    @ResponseBody
    public PythonDocPortalService.Package getPackageDoc(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String packageName) throws Exception {
        this.checkPermissions(req, projectKey);
        if (StringUtils.isEmpty((CharSequence)projectKey)) {
            return this.pythonDocPortalService.getGlobalPythonDoc(packageName);
        }
        return this.pythonDocPortalService.getProjectPythonDoc(projectKey, packageName);
    }

    private DSSAuthCtx checkPermissions(HttpServletRequest req, String projectKey) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            DSSAuthCtx u = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!u.isSafeCodeAllowed()) {
                throw new UnauthorizedException("No permission to write code", "lib-view-action-denied");
            }
            if (StringUtils.isNotEmpty((CharSequence)projectKey)) {
                this.permissionsService.checkProjectPrivileges((AuthCtx)u, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            DSSAuthCtx dSSAuthCtx = u;
            return dSSAuthCtx;
        }
    }

    @AuditedCall(value={"msgType", "docportal-list-packages"})
    @RequestMapping(value={"/api/docportal/list-packages"})
    @ResponseBody
    public List<String> listPackages(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey) throws IOException, DKUSecurityException {
        this.checkPermissions(req, projectKey);
        return this.pythonDocPortalService.listPackages(projectKey);
    }

    @AuditedCall(value={"msgType", "docportal-list-projects"})
    @RequestMapping(value={"/api/docportal/list-projects"})
    @ResponseBody
    public List<PythonDocPortalService.ProjectKeyWithName> listProjectsWithLibs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        DSSAuthCtx u = this.checkPermissions(req, null);
        return this.pythonDocPortalService.listProjectsWithLibs((AuthCtx)u);
    }

    @AuditedCall(value={"msgType", "docportal-list-accessible-projects"})
    @RequestMapping(value={"/api/docportal/list-accessible-projects"})
    @ResponseBody
    public List<PythonDocPortalService.ProjectKeyWithName> listAccessibleProjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        DSSAuthCtx u = this.checkPermissions(req, projectKey);
        return this.pythonDocPortalService.listProjectsUsableByProject((AuthCtx)u, projectKey);
    }

    @AuditedCall(value={"msgType", "docportal-search"})
    @RequestMapping(value={"/api/docportal/search"}, method={RequestMethod.GET})
    public void search(HttpServletRequest req, HttpServletResponse resp, @RequestParam String query, @RequestParam(required=false, defaultValue="10") int limit) throws Exception {
        DSSAuthCtx authCtx;
        LinkedHashMap aggregations = new LinkedHashMap();
        String trimmedQuery = query.trim();
        ArrayList<String> accessibleProjects = new ArrayList<String>();
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.checkPermissions(req, null);
            for (PythonDocPortalService.ProjectKeyWithName p : this.pythonDocPortalService.listProjectsWithLibs((AuthCtx)authCtx)) {
                accessibleProjects.add(p.projectKey);
            }
        }
        PythonDocPortalSearchService.Options pagesOptions = new PythonDocPortalSearchService.Options(limit);
        LuceneResponseWrapper response = this.pythonDocPortalSearchService.search(trimmedQuery, (AuthCtx)authCtx, pagesOptions, accessibleProjects);
        ArrayList searchHits = new ArrayList(response.hits);
        String jsonOutput = LuceneResponseWrapper.serializeHits(searchHits, null, aggregations, (Boolean)false);
        PythonDocPortalController.writeJSONString((HttpServletResponse)resp, (String)jsonOutput);
    }
}

