/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.external;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.ExternalTable;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.ConnectionMetadataDAO;
import com.dataiku.dip.dao.impl.ExternalCatalogInternalDB;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionsDumpService;
import com.dataiku.dip.server.connections.IndexingSessionContextData;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.services.ConnectionMetadataService;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.LuceneDocBuilder;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.external.ExternalDataCatalogService;
import com.dataiku.dip.server.services.catalog.external.ExternalTableSummary;
import com.dataiku.dip.sql.SQLDatabaseMetadataRetriever;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExternalCatalogIndexingQueueHandler
extends AbstractIndexingQueueHandler {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.catalog.external.handler");
    @Autowired
    private ConnectionMetadataService connectionMetadataService;
    @Autowired
    private ExternalCatalogInternalDB externalTableDAO;
    @Autowired
    private ConnectionsDumpService dumpService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    @Qualifier(value="externalMappingsAnalyzer")
    private LuceneMappingsAnalyzer externalLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="externalIndexManager")
    private LuceneIndexManager externalIndexManager;
    private static final String METRICS_PREFIX = "catalog.external.indexing.";
    public static final Set<String> FACETS = Set.of("_type", "catalog.raw", "connection.raw", "partitioned", "schema.raw", "tag.raw", "isInDataCollection");
    public static final Map<IndexableType, Set<String>> JSON_FIELDS = Map.ofEntries(Map.entry(IndexableType.TABLE, Set.of("columns", "datasets", "foreignKeys", "indexes", "partitioning", "rawRelatedItems", "rawTable", "recipes", "relatedItems", "security", "users")));
    public static final Set<String> MULTIVALUED_FIELDS = Set.of("column", "tag", "users");

    ExternalCatalogIndexingQueueHandler() {
        super("external-catalog-queue-handler");
        SpringUtils.getInstance().autowire((Object)this);
    }

    private List<String> addColumnsSection(LuceneDocBuilder mainDocument, JsonArray jsonColumn, String sectionName, List<SQLDatabaseMetadataRetriever.Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SQLDatabaseMetadataRetriever.Column column : columns) {
            JsonObject jsonColumnElement = new JsonObject();
            jsonColumnElement.addProperty("name", column.name);
            jsonColumnElement.addProperty("remarks", column.remarks);
            jsonColumnElement.addProperty("type", column.typeName);
            jsonColumnElement.addProperty("pseudoColumnUsage", column.pseudoColumnUsage);
            jsonColumn.add((JsonElement)jsonColumnElement);
            columnNames.add(column.name);
            mainDocument.addString(sectionName + ".name", column.name);
            mainDocument.addString(sectionName + ".remarks", column.remarks);
            mainDocument.addString(sectionName + ".type", column.typeName);
            mainDocument.addString(sectionName + ".pseudoColumnUsage", column.pseudoColumnUsage);
        }
        return columnNames;
    }

    public void indexConnections(Collection<String> connectionNames, Map<String, InfoMessage.InfoMessages> messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Indexing connections", (double)connectionNames.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            int i = 0;
            IndexingSessionContextData ctx = new IndexingSessionContextData();
            for (String connectionName : connectionNames) {
                InfoMessage.InfoMessages connectionMessages = messages.get(connectionName);
                if (connectionMessages == null) {
                    connectionMessages = new InfoMessage.InfoMessages();
                    messages.put(connectionName, connectionMessages);
                }
                FutureProgress.updateState((double)i++);
                try {
                    FutureProgress.AutocloseableFutureProgressState fp2 = FutureProgress.pushAutoCloseableState((String)("Indexing: " + connectionName));
                    try {
                        logger.infoV("Starting indexing connection : %s", new Object[]{connectionName});
                        this.indexConnection(ctx, connectionName, connectionMessages, this.externalIndexManager);
                        logger.infoV("Done indexing connection : %s", new Object[]{connectionName});
                    }
                    finally {
                        if (fp2 == null) continue;
                        fp2.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to index a connection " + connectionName), (Throwable)e);
                    connectionMessages.addMessage(InfoMessage.fatal((String)"Indexing", (String)MessageFormat.format("Failed to index connection {0}: {1}", connectionName, ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
            }
        }
        logger.debug((Object)"Complete reindexing done");
        this.externalIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
    }

    private void indexConnection(IndexingSessionContextData ctx, String connectionName, InfoMessage.InfoMessages connectionMessages, LuceneIndexManager indexManager) throws IOException, SQLException, DKUSecurityException, InterruptedException {
        String lockName = "dku.catalog.external.indexing.connection." + connectionName;
        try (AutoCloseableLock lock = NamedLock.acquire((String)lockName);){
            DSSConnection connection = this.connectionsDAO.getConnection((AuthCtx)DSSAuthCtx.newNone(), connectionName);
            long now = System.currentTimeMillis();
            ConnectionIndexingSessionContext cnxCtx = new ConnectionIndexingSessionContext(ctx);
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)(METRICS_PREFIX + connectionName.toLowerCase()));){
                this.deleteObjectsForConnection(connectionName, indexManager);
                if (connection == null) {
                    String message = MessageFormat.format("Failed to index connection {0}: connection does not exist", connectionName);
                    connectionMessages.addMessage(InfoMessage.fatal((String)"Indexing", (String)message));
                    logger.errorV(message, new Object[0]);
                } else {
                    Iterable tables = this.dumpService.iterateDump(connectionName);
                    for (ExternalTable externalTable : tables) {
                        ExternalCatalogInternalDB.ExternalTableDSSMetadata dssMetadata = this.externalTableDAO.getDSSMetadata(externalTable.key);
                        if (dssMetadata != null) {
                            externalTable.description = dssMetadata.description;
                            externalTable.tags = dssMetadata.tags;
                        }
                        connectionMessages.mergeFrom(cnxCtx.indexExternalTable(connection, externalTable));
                    }
                }
            }
            ConnectionMetadataDAO.ConnectionMetadata connectionMetadata = this.connectionMetadataService.getConnectionMetadata(connectionName);
            if (connectionMetadata == null) {
                connectionMetadata = new ConnectionMetadataDAO.ConnectionMetadata();
            }
            connectionMetadata.lastIndexDate = System.currentTimeMillis();
            connectionMetadata.lastIndexDuration = System.currentTimeMillis() - now;
            connectionMetadata.dssConnectionName = connectionName;
            connectionMetadata.messages = connectionMessages;
            this.connectionMetadataService.save(connectionMetadata);
        }
    }

    @Override
    public void handleQueueEvent(BackendEvent event) throws Exception {
        switch (event.getName()) {
            case "lucene-init-index": {
                TimeUnit.MILLISECONDS.sleep(AbstractSearchService.INITIAL_DELAY);
                boolean indexAllAtStartup = DKUApp.getParams().getBoolParam("dku.catalog.indexAtStartup", true);
                try {
                    logger.debug((Object)"Starting complete reindexing");
                    if (indexAllAtStartup) {
                        HashMap<String, InfoMessage.InfoMessages> messages = new HashMap<String, InfoMessage.InfoMessages>();
                        this.indexConnections(this.dumpService.getScannedConnections(), messages);
                        this.connectionMetadataService.saveMessages(messages);
                    } else {
                        logger.debug((Object)"Not indexing at startup");
                    }
                    this.initialized = true;
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)"Complete reindexing failed", (Throwable)e);
                }
            }
        }
    }

    private void deleteObjectsForConnection(String connectionName, LuceneIndexManager indexManager) throws IOException, InterruptedException {
        if (!indexManager.indexExists()) {
            return;
        }
        TermQuery searchQuery = new TermQuery(new Term("connection.raw", connectionName));
        this.deleteByQuery(indexManager, (Query)searchQuery);
    }

    private class ConnectionIndexingSessionContext {
        private final IndexingSessionContextData ctx;

        ConnectionIndexingSessionContext(IndexingSessionContextData ctx) {
            this.ctx = ctx;
        }

        private InfoMessage.InfoMessages indexExternalTable(DSSConnection connection, ExternalTable table) {
            LuceneDocBuilder doc = LuceneDocBuilder.from((String)ExternalDataCatalogService.TYPE, (LuceneMappingsAnalyzer)ExternalCatalogIndexingQueueHandler.this.externalLuceneMappingsAnalyzer, (String)table.key.toKey());
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            try {
                ExternalTableSummary.DSSItemsResponse relatedItems = this.ctx.getRelatedItems(table);
                HashSet<PublicUser> allUsers = new HashSet<PublicUser>();
                for (ExternalTableSummary.DSSItemsProject project : relatedItems.projects) {
                    for (ExternalTableSummary.DSSItemsDataset dataset : project.datasets) {
                        if (dataset.contributors == null) continue;
                        allUsers.addAll(dataset.contributors);
                    }
                }
                this.createTableObject(table, doc);
                this.createSecurityRules(connection, doc);
                this.createRelatedItemsSection(doc, relatedItems);
                for (PublicUser user : allUsers) {
                    doc.addString("users.login", user.login);
                    doc.addString("users.displayName", user.displayName);
                    doc.addString("users.email", user.email);
                }
                doc.addJson("users", JSON.json(allUsers));
                doc.addBoolean("isInDataCollection", Boolean.valueOf(false));
                ExternalCatalogIndexingQueueHandler.this.externalIndexManager.addDocument(doc);
            }
            catch (Exception t) {
                messages.addMessage(InfoMessage.fatal((String)"Indexing failed", (String)String.format("Failed to index table %s in connection %s, %s", table.key.toString(), connection, ExceptionUtils.getMessageWithCauses((Throwable)t))));
                logger.errorV((Throwable)t, "Error while indexing table %s", new Object[]{table.key.toString()});
            }
            return messages;
        }

        private void createTableObject(ExternalTable table, LuceneDocBuilder mainDocument) {
            JsonObject rawTableJson = (JsonObject)new Gson().fromJson(JSON.json((Object)table), JsonObject.class);
            mainDocument.addJson("rawTable", rawTableJson.toString());
            mainDocument.addString("name", table.key.name);
            mainDocument.addString("catalog", table.key.catalog);
            mainDocument.addString("schema", table.key.schema);
            mainDocument.addString("type", table.type);
            mainDocument.addString("remarks", table.remarks);
            mainDocument.addString("description", table.description);
            mainDocument.addStrings("tag", (Collection)table.tags);
            mainDocument.addString("connection", table.key.connectionName);
            mainDocument.addString("connectionType", table.connectionType);
            ArrayList<String> columnNames = new ArrayList<String>(table.columns.size());
            JsonArray jsonColumns = new JsonArray();
            columnNames.addAll(ExternalCatalogIndexingQueueHandler.this.addColumnsSection(mainDocument, jsonColumns, "columns", table.columns));
            mainDocument.addJson("columns", gson.toJson((JsonElement)jsonColumns));
            JsonArray jsonPartitioning = new JsonArray();
            columnNames.addAll(ExternalCatalogIndexingQueueHandler.this.addColumnsSection(mainDocument, jsonPartitioning, "partitioning", table.partitionColumns));
            mainDocument.addJson("partitioning", gson.toJson((JsonElement)jsonPartitioning));
            mainDocument.addStrings("column", columnNames);
            mainDocument.addBoolean("partitioned", Boolean.valueOf(table.isPartitioned));
            JsonArray jsonForeignKeys = new JsonArray();
            for (SQLDatabaseMetadataRetriever.ForeignKey foreignKey : table.foreignKeys) {
                mainDocument.addString("foreignKeys.pkColumnName", foreignKey.pkColumnName);
                mainDocument.addString("foreignKeys.fkColumnName", foreignKey.fkColumnName);
                mainDocument.addString("foreignKeys.pkName", foreignKey.pkName);
                mainDocument.addString("foreignKeys.fkName", foreignKey.fkName);
                JsonObject jsonForeignKeyElement = new JsonObject();
                jsonForeignKeyElement.addProperty("pkName", foreignKey.pkName);
                jsonForeignKeyElement.addProperty("pkColumnName", foreignKey.pkColumnName);
                jsonForeignKeyElement.addProperty("fkName", foreignKey.fkName);
                jsonForeignKeyElement.addProperty("fkColumnName", foreignKey.fkColumnName);
                this.indexKey(mainDocument, jsonForeignKeyElement, foreignKey.pkTableKey, "pkTableKey");
                this.indexKey(mainDocument, jsonForeignKeyElement, foreignKey.fkTableKey, "fkTableKey");
                jsonForeignKeys.add((JsonElement)jsonForeignKeyElement);
            }
            mainDocument.addJson("foreignKeys", gson.toJson((JsonElement)jsonForeignKeys));
            JsonArray jsonIndexes = new JsonArray();
            for (SQLDatabaseMetadataRetriever.Index index : table.indexes) {
                mainDocument.addString("indexes.name", index.name);
                mainDocument.addString("indexes.columnName", index.columnName);
                JsonObject jsonIndexElement = new JsonObject();
                jsonIndexElement.addProperty("name", index.name);
                jsonIndexElement.addProperty("columnName", index.columnName);
                jsonIndexElement.addProperty("condition", index.condition);
                jsonIndexes.add((JsonElement)jsonIndexElement);
            }
            mainDocument.addJson("indexes", gson.toJson((JsonElement)jsonIndexes));
            mainDocument.addInt("numColumns", Integer.valueOf(table.columns.size()));
        }

        private void createSecurityRules(DSSConnection connection, LuceneDocBuilder doc) {
            JsonObject jsonSecurity = new JsonObject();
            if (connection instanceof HiveConnection) {
                doc.addString("security.accessPolicy", "INDEXED_HIVE");
                jsonSecurity.addProperty("accessPolicy", "INDEXED_HIVE");
            } else {
                jsonSecurity.addProperty("accessPolicy", connection.usableBy.toString());
                for (String allowedGroup : connection.allowedGroups) {
                    doc.addString("security.accessGroups", allowedGroup);
                }
                jsonSecurity.add("accessGroups", gson.toJsonTree((Object)connection.allowedGroups));
                jsonSecurity.addProperty("owner", connection.owner);
                doc.addString("security.accessPolicy", connection.usableBy.name());
                doc.addString("security.owner", connection.owner);
            }
            doc.addJson("security", gson.toJson((JsonElement)jsonSecurity));
        }

        private void createRelatedItemsSection(LuceneDocBuilder doc, ExternalTableSummary.DSSItemsResponse related) {
            doc.addJson("rawRelatedItems", JSON.json((Object)related));
            ExternalTableSummary.DSSItemsResponse searchableRelated = (ExternalTableSummary.DSSItemsResponse)JSON.deepCopy((Object)related);
            for (ExternalTableSummary.DSSItemsProject p : searchableRelated.projects) {
                ListIterator<ExternalTableSummary.DSSItemsDataset> it = p.datasets.listIterator();
                while (it.hasNext()) {
                    ExternalTableSummary.DSSItemsDataset d = it.next();
                    if (d.foreign) {
                        it.remove();
                    }
                    d.recipes = null;
                }
            }
            for (ExternalTableSummary.DSSItemsProject project : searchableRelated.projects) {
                doc.addString("relatedItems.projects.name", project.name);
                doc.addString("relatedItems.projects.key", project.key);
                for (ExternalTableSummary.DSSItemsDataset dataset : project.datasets) {
                    doc.addString("relatedItems.projects.datasets.name", dataset.name);
                    doc.addString("relatedItems.projects.datasets.description", dataset.description);
                    for (PublicUser contributor : dataset.contributors) {
                        doc.addString("relatedItems.projects.datasets.contributors.login", contributor.login);
                        doc.addString("relatedItems.projects.datasets.contributors.displayName", contributor.displayName);
                        doc.addString("relatedItems.projects.datasets.contributors.email", contributor.email);
                    }
                }
            }
        }

        private void indexKey(LuceneDocBuilder doc, JsonObject jsonObject, DatabaseObjectKey key, String fieldName) {
            String prefix = "foreignKeys." + (fieldName == null ? "key" : fieldName);
            doc.addString(prefix + ".name", key.name);
            doc.addString(prefix + ".catalog", key.catalog);
            doc.addString(prefix + ".schema", key.schema);
            JsonObject subJson = new JsonObject();
            subJson.addProperty("name", key.name);
            subJson.addProperty("catalog", key.catalog);
            subJson.addProperty("schema", key.schema);
            jsonObject.add(fieldName == null ? "key" : fieldName, (JsonElement)subJson);
        }
    }
}

