/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.artifacts.ArtifactDescription;
import com.dataiku.gh.core.models.governance.InputGovernanceSettings;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.governance.IGovernanceCoordinatorService;
import com.dataiku.gh.core.services.governance.hide.IGovernanceHideService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GovernanceController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IGovernanceCoordinatorService governanceCoordinatorService;
    @Autowired
    private IGovernanceHideService governanceHideService;

    @AuditInline
    @RequestMapping(value={"/api/governance/govern"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GOVERN_ARTIFACT)
    @ResponseBody
    public ArtifactDescription govern(HttpServletRequest req, @RequestParam String artifactId, @RequestParam InputGovernanceSettings inputGovernanceSettings) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.governanceCoordinatorService.manualGovern(authCtx, artifactId, inputGovernanceSettings);
            this.auditTrailService.generic("governance-govern").with("artifactId", artifactId).emit();
            return ArtifactDescription.build(artifactId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("governance-govern", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "governance-set-multiple-visibilities", "artifactIds", "${artifactIds}", "hidden", "${hidden}"})
    @RequestMapping(value={"/api/governance/set-multiple-visibilities"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.GOVERN_MULTIPLE_VISIBILITIES_UPDATE)
    @ResponseBody
    public List<ArtifactDescription> setMultipleVisibilities(HttpServletRequest req, @RequestParam List<String> artifactIds, @RequestParam Boolean hidden) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.governanceHideService.setArtifactVisibilities(authCtx, artifactIds, hidden).stream().map(ArtifactDescription::build).collect(Collectors.toList());
    }
}

