/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.blueprints;

import com.dataiku.dip.logging.LoggableAPIResource;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.blueprints.WorkflowDefinition;
import com.dataiku.gh.core.models.blueprints.ui.UIDefinition;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.visitors.IBlueprintVersionVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@UIModel
public class BlueprintVersion
implements LoggableAPIResource {
    public BlueprintVersionId id;
    @UINullable
    public String name;
    public Map<String, FieldDefinition> fieldDefinitions = new HashMap<String, FieldDefinition>();
    public WorkflowDefinition workflowDefinition = new WorkflowDefinition();
    public List<LogicalHook> logicalHookList = new ArrayList<LogicalHook>();
    @UINullable
    public String hierarchicalParentFieldId;
    public UIDefinition uiDefinition = new UIDefinition();
    @UINullable
    public String instructions;

    public void accept(IBlueprintVersionVisitor blueprintVersionVisitor) {
        this.id.accept(blueprintVersionVisitor);
        this.fieldDefinitions.forEach((fieldId, fieldDefinition) -> fieldDefinition.accept(blueprintVersionVisitor, (String)fieldId));
        this.workflowDefinition.accept(blueprintVersionVisitor);
        this.logicalHookList.forEach(hook -> hook.accept(blueprintVersionVisitor));
        this.uiDefinition.accept(blueprintVersionVisitor);
        blueprintVersionVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlueprintVersion that = (BlueprintVersion)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.fieldDefinitions, that.fieldDefinitions) && Objects.equals(this.workflowDefinition, that.workflowDefinition) && Objects.equals(this.logicalHookList, that.logicalHookList) && Objects.equals(this.hierarchicalParentFieldId, that.hierarchicalParentFieldId) && Objects.equals(this.uiDefinition, that.uiDefinition) && Objects.equals(this.instructions, that.instructions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.fieldDefinitions, this.workflowDefinition, this.logicalHookList, this.hierarchicalParentFieldId, this.uiDefinition, this.instructions);
    }

    public Map<String, Object> getLoggableIdentifiers() {
        return Collections.singletonMap("id", this.id);
    }

    public static BlueprintVersion build(BlueprintVersionId blueprintVersionId, String name) {
        BlueprintVersion blueprintVersion = new BlueprintVersion();
        blueprintVersion.id = blueprintVersionId;
        blueprintVersion.name = name;
        return blueprintVersion;
    }

    public static BlueprintVersion build(BlueprintVersionId id, @Nullable String name, Map<String, FieldDefinition> fieldDefinitions, WorkflowDefinition workflowDefinition, List<LogicalHook> logicalHookList, @Nullable String hierarchicalParentFieldId, UIDefinition uiDefinition, @Nullable String instructions) {
        BlueprintVersion blueprintVersion = BlueprintVersion.build(id, name);
        blueprintVersion.fieldDefinitions = fieldDefinitions;
        blueprintVersion.workflowDefinition = workflowDefinition;
        blueprintVersion.logicalHookList = logicalHookList;
        blueprintVersion.hierarchicalParentFieldId = hierarchicalParentFieldId;
        blueprintVersion.uiDefinition = uiDefinition;
        blueprintVersion.instructions = instructions;
        return blueprintVersion;
    }
}

