/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.governance;

import javax.annotation.Nullable;

public class GovernanceResult {
    public String dataikuArtifactId;
    @Nullable
    public String governArtifactId;
    public GovernanceResultStatus status;
    public GovernanceResultStatusReason reason;

    public static GovernanceResult buildNothing(String dataikuArtifactId, GovernanceResultStatusReason reason) {
        GovernanceResult result = new GovernanceResult();
        result.status = GovernanceResultStatus.DID_NOTHING;
        result.dataikuArtifactId = dataikuArtifactId;
        result.reason = reason;
        return result;
    }

    public static GovernanceResult buildGoverned(String dataikuArtifactId, String governArtifactId) {
        GovernanceResult result = new GovernanceResult();
        result.status = GovernanceResultStatus.GOVERNED;
        result.dataikuArtifactId = dataikuArtifactId;
        result.governArtifactId = governArtifactId;
        result.reason = GovernanceResultStatusReason.AS_STATED;
        return result;
    }

    public static GovernanceResult buildHidden(String dataikuArtifactId, GovernanceResultStatusReason reason) {
        GovernanceResult result = new GovernanceResult();
        result.status = GovernanceResultStatus.HIDDEN;
        result.dataikuArtifactId = dataikuArtifactId;
        result.reason = reason;
        return result;
    }

    public String toString() {
        return "GovernanceResult{dataikuArtifactId='" + this.dataikuArtifactId + "', governArtifactId='" + this.governArtifactId + "', status=" + String.valueOf((Object)this.status) + ", reason=" + String.valueOf((Object)this.reason) + "}";
    }

    public static enum GovernanceResultStatus {
        GOVERNED,
        HIDDEN,
        DID_NOTHING;

    }

    public static enum GovernanceResultStatusReason {
        AS_STATED,
        ALREADY_GOVERNED,
        ALREADY_HIDDEN,
        PARENT_NOT_GOVERNED,
        PARENT_HIDDEN,
        LICENSE_RESTRICTION,
        ERROR;

    }
}

