/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.notifications.common;

import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.notifications.NotificationContextUtils;
import com.dataiku.gh.core.models.notifications.PermissionProtectedTemplateContext;
import com.dataiku.gh.core.models.notifications.TemplateContext;
import com.dataiku.gh.core.models.notifications.common.UserTemplateContext;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FeedbackTemplateContext
extends PermissionProtectedTemplateContext {
    private final SignoffFeedback signoffFeedback;
    private final SignoffConfiguration signoffConfiguration;
    private final UserTemplateContext feedbackUserTemplateContext;

    public FeedbackTemplateContext(EnrichedArtifact enrichedArtifact, SignoffFeedback signoffFeedback, SignoffConfiguration signoffConfiguration) {
        super(enrichedArtifact);
        this.signoffFeedback = signoffFeedback;
        this.signoffConfiguration = signoffConfiguration;
        this.feedbackUserTemplateContext = new UserTemplateContext(signoffFeedback.user);
    }

    public List<TemplateContext> getChildren() {
        return Collections.singletonList(this.feedbackUserTemplateContext);
    }

    public SimpleHash buildTemplateModel() {
        if (!this.userCanSeeContext()) {
            return null;
        }
        SimpleHash data = new SimpleHash((ObjectWrapper)WRAPPER_BUILDER.build());
        data.put("user", (Object)this.feedbackUserTemplateContext.buildTemplateModel());
        data.put("comment", (Object)this.signoffFeedback.comment);
        data.put("status", (Object)this.signoffFeedback.status.toString());
        data.put("group", (Object)this.signoffConfiguration.findFeedbackGroupById((String)this.signoffFeedback.groupId).get().title);
        data.put("creationDate", (Object)NotificationContextUtils.parseDate(this.signoffFeedback.creationDate));
        if (StringUtils.isNotBlank((CharSequence)this.signoffFeedback.editionDate)) {
            data.put("editionDate", (Object)NotificationContextUtils.parseDate(this.signoffFeedback.editionDate));
        }
        return data;
    }
}

