/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactPostFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchPagination;
import com.dataiku.gh.core.models.search.ArtifactSearchSort;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.visitors.IArtifactSearchQueryVisitor;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class ArtifactSearchQuery {
    public ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource = new ArtifactSearchSourceConfig.AllArtifactSearchSource();
    public List<ArtifactFilter> artifactFilters = new ArrayList<ArtifactFilter>();
    @UINullable
    public ArtifactSearchSort artifactSearchSort;
    @UINullable
    public ArtifactSearchPagination artifactSearchPagination;
    @UINullable
    public List<ArtifactPostFilter> artifactPostFilters = new ArrayList<ArtifactPostFilter>();

    public void accept(IArtifactSearchQueryVisitor artifactSearchQueryVisitor) {
        this.artifactSearchSource.accept(artifactSearchQueryVisitor);
        this.artifactFilters.forEach(filter -> filter.accept(artifactSearchQueryVisitor));
        if (this.artifactSearchSort != null) {
            this.artifactSearchSort.accept(artifactSearchQueryVisitor);
        }
        if (this.artifactSearchPagination != null) {
            this.artifactSearchPagination.accept(artifactSearchQueryVisitor);
        }
        if (this.artifactPostFilters != null) {
            this.artifactPostFilters.forEach(filter -> filter.accept(artifactSearchQueryVisitor));
        }
        artifactSearchQueryVisitor.visit(this);
    }

    public static ArtifactSearchQuery build(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource) {
        return ArtifactSearchQuery.build(artifactSearchSource, null);
    }

    public static ArtifactSearchQuery build(ArtifactFilter ... artifactFilters) {
        return ArtifactSearchQuery.build(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Arrays.asList(artifactFilters));
    }

    public static ArtifactSearchQuery build(@Nullable List<ArtifactFilter> artifactFilters) {
        return ArtifactSearchQuery.build(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), artifactFilters);
    }

    public static ArtifactSearchQuery build(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters) {
        return ArtifactSearchQuery.build(artifactSearchSource, artifactFilters, null, null, null);
    }

    public static ArtifactSearchQuery build(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters, @Nullable ArtifactSearchSort artifactSearchSort, @Nullable ArtifactSearchPagination artifactSearchPagination, @Nullable List<ArtifactPostFilter> artifactPostFilters) {
        ArtifactSearchQuery query = new ArtifactSearchQuery();
        query.artifactSearchSource = artifactSearchSource;
        query.artifactFilters = artifactFilters != null ? artifactFilters : Lists.newArrayList();
        query.artifactSearchSort = artifactSearchSort;
        query.artifactSearchPagination = artifactSearchPagination;
        query.artifactPostFilters = artifactPostFilters;
        return query;
    }
}

