/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.plugins.IPluginsRegistryService;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIPluginsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;

    @AuditedCall(value={"msgType", "plugin-action-run", "pluginId", "${pluginId}", "actionId", "${actionId}"})
    @RequestMapping(value={"/publicapi/plugins/{pluginId}/actions/{actionId}/run"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.PLUGIN_ACTION_RUN)
    public void runAction(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @PathVariable String actionId) throws Exception {
        JsonObject params = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIPluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsRegistryService.runAction(authCtx, pluginId, actionId, null, params));
    }
}

