/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV12200AndV13099;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV12200
extends Migration {
    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        this.migrateSignoffsTable(dbMigrationDAO);
        this.migrateSignoffsHistoryTable(dbMigrationDAO);
        this.migrateSignoffConfigurationsTable(dbMigrationDAO);
        this.migrateSignoffConfigurationsHistoryTable(dbMigrationDAO);
    }

    @VisibleForTesting
    protected static boolean isMandatorySignoff(String blueprintId, String versionId, String stepId) {
        return (blueprintId.equals("bp.system.govern_model_version") || blueprintId.equals("bp.system.govern_bundle")) && versionId.equals("bv.system.default") && stepId.equals("review");
    }

    @VisibleForTesting
    protected static List<MigratedSignoff> migrateSignoff(ToMigrateArtifactSignoff toMigrateArtifactSignoff) {
        JsonObject artifactSignoffs = toMigrateArtifactSignoff.artifactSignoff;
        ArrayList<MigratedSignoff> migratedSignoffs = new ArrayList<MigratedSignoff>();
        String artifactId = MigrationJsonUtils.getStringSubpath((JsonElement)artifactSignoffs, "artifactId").orElse("");
        JsonArray signoffs = MigrationJsonUtils.getArraySubpath((JsonElement)artifactSignoffs, "signoffs").orElse(new JsonArray());
        for (JsonElement signoff : signoffs) {
            String stepId = MigrationJsonUtils.getStringSubpath(signoff, "stepId").orElse("");
            JsonObject signoffId = new JsonObject();
            signoffId.addProperty("stepId", stepId);
            signoffId.addProperty("artifactId", artifactId);
            JsonArray cycles = MigrationJsonUtils.getArraySubpath(signoff, "cycles").orElse(new JsonArray());
            if (cycles.isEmpty()) continue;
            JsonObject cycle = cycles.get(cycles.size() - 1).getAsJsonObject();
            if (cycle.has("configuration")) {
                JsonObject configuration = cycle.getAsJsonObject("configuration");
                configuration.add("id", (JsonElement)MigrationEntitiesUtilsBetweenV12200AndV13099.buildSignoffConfigurationId(MigrationEntitiesUtilsBetweenV12200AndV13099.buildBlueprintVersionId(toMigrateArtifactSignoff.blueprintId, toMigrateArtifactSignoff.versionId), stepId));
                configuration.addProperty("mandatory", Boolean.valueOf(MigrationV12200.isMandatorySignoff(toMigrateArtifactSignoff.blueprintId, toMigrateArtifactSignoff.versionId, stepId)));
            }
            cycle.addProperty("cycleIndex", (Number)0);
            cycle.add("signoffId", (JsonElement)signoffId);
            if (MigrationJsonUtils.getStringSubpath((JsonElement)cycle, "status").orElse("").equals("ABANDONED")) {
                String statusBeforeAbandoned = "NOT_STARTED";
                String approverResponse = MigrationJsonUtils.getStringSubpath((JsonElement)cycle, "approverResponse", "status").orElse("");
                if (StringUtils.equals((CharSequence)approverResponse, (CharSequence)"APPROVED") || StringUtils.equals((CharSequence)approverResponse, (CharSequence)"REJECTED")) {
                    statusBeforeAbandoned = approverResponse;
                } else if (StringUtils.equals((CharSequence)approverResponse, (CharSequence)"ABANDONED")) {
                    statusBeforeAbandoned = "WAITING_FOR_APPROVAL";
                } else if (!MigrationJsonUtils.getArraySubpath((JsonElement)cycle, "feedbackResponses").orElse(new JsonArray()).isEmpty()) {
                    statusBeforeAbandoned = "WAITING_FOR_FEEDBACK";
                }
                cycle.addProperty("statusBeforeAbandoned", statusBeforeAbandoned);
            }
            cycle.remove("feedbackResponsesHistory");
            cycle.remove("approverResponsesHistory");
            if (cycle.has("approverResponse")) {
                JsonObject approverResponse = cycle.getAsJsonObject("approverResponse");
                String statusDate = MigrationJsonUtils.getStringSubpath((JsonElement)approverResponse, "statusDate").orElse("");
                approverResponse.addProperty("creationDate", statusDate);
                approverResponse.remove("statusDate");
            }
            JsonArray feedbackResponses = MigrationJsonUtils.getArraySubpath((JsonElement)cycle, "feedbackResponses").orElse(new JsonArray());
            HashSet<String> usedUUIDs = new HashSet<String>();
            for (JsonElement feedbackResponseElement : feedbackResponses) {
                if (!feedbackResponseElement.isJsonObject()) continue;
                JsonObject feedbackResponse = feedbackResponseElement.getAsJsonObject();
                feedbackResponse.addProperty("id", MigrationEntitiesUtilsBetweenV12200AndV13099.generateUUID(usedUUIDs));
                String statusDate = MigrationJsonUtils.getStringSubpath((JsonElement)feedbackResponse, "statusDate").orElse("");
                feedbackResponse.addProperty("creationDate", statusDate);
                feedbackResponse.remove("statusDate");
            }
            migratedSignoffs.add(new MigratedSignoff().setSignoff(cycle));
        }
        return migratedSignoffs;
    }

    @VisibleForTesting
    protected static List<HistoryMigration<MigratedSignoff>> migrateSignoffHistory(JdbcTemplate querydslJdbcTemplate, HistoryMigration<ToMigrateArtifactSignoff> artifactSignoffsHistory) throws IOException {
        JsonObject revision = artifactSignoffsHistory.revision;
        ToMigrateArtifactSignoff signoff = (ToMigrateArtifactSignoff)artifactSignoffsHistory.entity;
        ArrayList<HistoryMigration<MigratedSignoff>> migratedSignoffHistory = new ArrayList<HistoryMigration<MigratedSignoff>>();
        List<MigratedSignoff> migratedSignoffs = MigrationV12200.migrateSignoff(signoff);
        for (int n = 0; n < migratedSignoffs.size(); ++n) {
            JsonObject migratedRevision = revision.deepCopy();
            migratedRevision.addProperty("entityType", "SIGNOFF");
            MigratedSignoff migratedSignoff = migratedSignoffs.get(n);
            if (n > 0) {
                try {
                    long newId = MigrationEntitiesUtilsBetweenV12200AndV13099.newRevisionId(querydslJdbcTemplate);
                    migratedRevision.addProperty("id", (Number)newId);
                }
                catch (DataStoreIOException e) {
                    throw new IOException("Could not retrieve new revision id for migrated object", e);
                }
            }
            migratedSignoffHistory.add(new HistoryMigration<MigratedSignoff>().setEntity(migratedSignoff).setRevision(migratedRevision));
        }
        return migratedSignoffHistory;
    }

    private void migrateSignoffsTable(IDBMigrationDAO dbMigrationDAO) throws IOException {
        JdbcTemplate querydslJdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        String sqlSelectAll = "SELECT artifacts.artifact_blueprint_id, artifacts.artifact_version_id, artifact_signoffs_json\nFROM artifact_signoffs\njoin artifacts on artifacts.artifact_id = artifact_signoffs.artifact_signoffs_artifact_id";
        String sqlInsert = "INSERT INTO signoffs (signoff_json) VALUES (?::jsonb)";
        try (Stream selectStream = querydslJdbcTemplate.queryForStream(sqlSelectAll, (rs, rowNum) -> new ToMigrateArtifactSignoff().setArtifactSignoff((JsonObject)JSON.parse((String)rs.getString("artifact_signoffs_json"), JsonObject.class)).setBlueprintId(rs.getString("artifact_blueprint_id")).setVersionId(rs.getString("artifact_version_id")));){
            Iterator selectIterator = selectStream.map(MigrationV12200::migrateSignoff).flatMap(Collection::stream).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToInsert -> querydslJdbcTemplate.batchUpdate(sqlInsert, (Collection)listToInsert, 100, (ps, toInsert) -> ps.setString(1, JSON.json((Object)toInsert.signoff))));
            logger.info((Object)"Migrated sign-offs to new format");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    private void migrateSignoffsHistoryTable(IDBMigrationDAO dbMigrationDAO) throws IOException {
        JdbcTemplate querydslJdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        String sqlSelectAllHistory = "SELECT artifact_blueprint_id, artifact_version_id, artifact_signoffs_history._revision_json, artifact_signoffs_json\nFROM artifact_signoffs_history, LATERAL (\n    SELECT artifact_blueprint_id, artifact_version_id\n    FROM artifacts_history\n    WHERE artifacts_history.artifact_id = artifact_signoffs_history.artifact_signoffs_artifact_id\n    LIMIT 1\n) ARTIFACT_HISTORY_FIRST_ROW";
        String sqlInsertHistory = "INSERT INTO signoffs_history (_revision_json, signoff_json) VALUES (?::jsonb, ?::jsonb)";
        try (Stream selectStream = querydslJdbcTemplate.queryForStream(sqlSelectAllHistory, (rs, rowNum) -> new HistoryMigration<ToMigrateArtifactSignoff>().setEntity(new ToMigrateArtifactSignoff().setBlueprintId(rs.getString("artifact_blueprint_id")).setVersionId(rs.getString("artifact_version_id")).setArtifactSignoff((JsonObject)JSON.parse((String)rs.getString("artifact_signoffs_json"), JsonObject.class))).setRevision((JsonObject)JSON.parse((String)rs.getString("_revision_json"), JsonObject.class)));){
            Iterator selectIterator = selectStream.map(row -> {
                try {
                    return MigrationV12200.migrateSignoffHistory(querydslJdbcTemplate, row);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).flatMap(Collection::stream).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToInsert -> querydslJdbcTemplate.batchUpdate(sqlInsertHistory, (Collection)listToInsert, 100, (ps, toInsert) -> {
                ps.setString(1, JSON.json((Object)toInsert.revision));
                ps.setString(2, JSON.json((Object)((MigratedSignoff)toInsert.entity).signoff));
            }));
            logger.info((Object)"Migrated sign-offs history to new format");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @VisibleForTesting
    protected static List<MigratedSignoffConfiguration> migrateBlueprintVersionSignoffConfiguration(ToMigrateBlueprintVersionSignoffsConfigurations toMigrate) {
        JsonObject blueprintVersionSignoffsConfigurations = toMigrate.blueprintVersionSignoffsConfigurations;
        Optional<JsonObject> blueprintVersionIdOpt = MigrationJsonUtils.getObjectSubpath((JsonElement)blueprintVersionSignoffsConfigurations, "blueprintVersionId");
        if (!blueprintVersionIdOpt.isPresent()) {
            return Collections.emptyList();
        }
        JsonObject blueprintVersionId = blueprintVersionIdOpt.get();
        JsonArray signoffConfigurationHolders = MigrationJsonUtils.getArraySubpath((JsonElement)blueprintVersionSignoffsConfigurations, "signoffConfigurationHolders").orElse(new JsonArray());
        ArrayList<MigratedSignoffConfiguration> migratedSignoffsConfigurations = new ArrayList<MigratedSignoffConfiguration>();
        MigrationV12200.migrateSignoffConfigurationHoldersToSignoffConfigurations(blueprintVersionId, signoffConfigurationHolders).forEach(signoffConfiguration -> migratedSignoffsConfigurations.add(new MigratedSignoffConfiguration().setSignoffConfiguration(signoffConfiguration.getAsJsonObject())));
        return migratedSignoffsConfigurations;
    }

    public static JsonArray migrateSignoffConfigurationHoldersToSignoffConfigurations(JsonObject blueprintVersionId, JsonArray signoffConfigurationHolders) {
        JsonArray signoffConfigurations = new JsonArray();
        HashSet<String> knownStepIds = new HashSet<String>();
        for (JsonElement signoffConfigurationHolder : signoffConfigurationHolders) {
            Optional<String> stepIdOpt = MigrationJsonUtils.getStringSubpath(signoffConfigurationHolder, "stepId");
            Optional<JsonObject> signoffConfigurationOpt = MigrationJsonUtils.getObjectSubpath(signoffConfigurationHolder, "signoffConfiguration");
            if (!stepIdOpt.isPresent() || !signoffConfigurationOpt.isPresent()) continue;
            String stepId = stepIdOpt.get();
            JsonObject signoffConfiguration = signoffConfigurationOpt.get();
            if (knownStepIds.contains(stepId)) continue;
            knownStepIds.add(stepId);
            signoffConfiguration.add("id", (JsonElement)MigrationEntitiesUtilsBetweenV12200AndV13099.buildSignoffConfigurationId(blueprintVersionId, stepId));
            String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)blueprintVersionId, "blueprintId").orElse("");
            String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)blueprintVersionId, "versionId").orElse("");
            signoffConfiguration.addProperty("mandatory", Boolean.valueOf(MigrationV12200.isMandatorySignoff(blueprintId, versionId, stepId)));
            signoffConfigurations.add((JsonElement)signoffConfiguration);
        }
        return signoffConfigurations;
    }

    private void migrateSignoffConfigurationsTable(IDBMigrationDAO dbMigrationDAO) throws IOException {
        JdbcTemplate querydslJdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        String sqlSelectAll = "SELECT blueprint_version_signoff_configurations_json FROM blueprint_version_signoff_configurations";
        String sqlInsert = "INSERT INTO signoff_configurations (signoff_configuration_json) VALUES (?::jsonb)";
        try (Stream selectStream = querydslJdbcTemplate.queryForStream(sqlSelectAll, (rs, rowNum) -> new ToMigrateBlueprintVersionSignoffsConfigurations().setBlueprintVersionSignoffsConfigurations((JsonObject)JSON.parse((String)rs.getString("blueprint_version_signoff_configurations_json"), JsonObject.class)));){
            Iterator selectIterator = selectStream.map(MigrationV12200::migrateBlueprintVersionSignoffConfiguration).flatMap(Collection::stream).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToInsert -> querydslJdbcTemplate.batchUpdate(sqlInsert, (Collection)listToInsert, 100, (ps, toInsert) -> ps.setString(1, JSON.json((Object)toInsert.signoffConfiguration))));
            logger.info((Object)"Migrated signoffsConfigurations to new format");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    private void migrateSignoffConfigurationsHistoryTable(IDBMigrationDAO dbMigrationDAO) throws IOException {
        JdbcTemplate querydslJdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        String sqlSelectAllHistory = "SELECT _revision_json, blueprint_version_signoff_configurations_json FROM blueprint_version_signoff_configurations_history";
        String sqlInsertHistory = "INSERT INTO signoff_configurations_history (_revision_json, signoff_configuration_json) VALUES (?::jsonb, ?::jsonb)";
        try (Stream selectStream = querydslJdbcTemplate.queryForStream(sqlSelectAllHistory, (rs, rowNum) -> new HistoryMigration().setRevision((JsonObject)JSON.parse((String)rs.getString("_revision_json"), JsonObject.class)).setEntity(new ToMigrateBlueprintVersionSignoffsConfigurations().setBlueprintVersionSignoffsConfigurations((JsonObject)JSON.parse((String)rs.getString("blueprint_version_signoff_configurations_json"), JsonObject.class))));){
            Iterator selectIterator = selectStream.map(row -> {
                try {
                    return MigrationV12200.migrateSignoffConfigurationHistory(querydslJdbcTemplate, row);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).flatMap(Collection::stream).iterator();
            Iterators.partition(selectIterator, (int)100).forEachRemaining(listToInsert -> querydslJdbcTemplate.batchUpdate(sqlInsertHistory, (Collection)listToInsert, 100, (ps, toInsert) -> {
                ps.setString(1, JSON.json((Object)toInsert.revision));
                ps.setString(2, JSON.json((Object)((MigratedSignoffConfiguration)toInsert.entity).signoffConfiguration));
            }));
            logger.info((Object)"Migrated sign-offs history to new format");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    @VisibleForTesting
    protected static List<HistoryMigration<MigratedSignoffConfiguration>> migrateSignoffConfigurationHistory(JdbcTemplate querydslJdbcTemplate, HistoryMigration<ToMigrateBlueprintVersionSignoffsConfigurations> toMigrate) throws IOException {
        JsonObject revision = toMigrate.revision;
        ToMigrateBlueprintVersionSignoffsConfigurations revisionAndBPVSignoffConfigurations = (ToMigrateBlueprintVersionSignoffsConfigurations)toMigrate.entity;
        ArrayList<HistoryMigration<MigratedSignoffConfiguration>> migratedSignoffConfigurationHistory = new ArrayList<HistoryMigration<MigratedSignoffConfiguration>>();
        List<MigratedSignoffConfiguration> migratedSignoffConfigurations = MigrationV12200.migrateBlueprintVersionSignoffConfiguration(revisionAndBPVSignoffConfigurations);
        for (int n = 0; n < migratedSignoffConfigurations.size(); ++n) {
            JsonObject migratedRevision = revision.deepCopy();
            migratedRevision.addProperty("entityType", "SIGNOFF_CONFIGURATION");
            MigratedSignoffConfiguration migratedSignoffConfiguration = migratedSignoffConfigurations.get(n);
            if (n > 0) {
                try {
                    long newId = MigrationEntitiesUtilsBetweenV12200AndV13099.newRevisionId(querydslJdbcTemplate);
                    migratedRevision.addProperty("id", (Number)newId);
                }
                catch (DataStoreIOException e) {
                    throw new IOException("Could not retrieve new revision id for migrated object", e);
                }
            }
            migratedSignoffConfigurationHistory.add(new HistoryMigration<MigratedSignoffConfiguration>().setEntity(migratedSignoffConfiguration).setRevision(migratedRevision));
        }
        return migratedSignoffConfigurationHistory;
    }

    @Override
    public void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        if (providedObjectsFolder == null) {
            throw new ValidationException("Migration " + this.getClass().getSimpleName() + " is expecting a provided object folder");
        }
        long migrationTS = this.getMigrationTimestamp();
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        Long actionId = MigrationEntitiesUtilsBetweenV12200AndV13099.createMigrationAction(jdbcTemplate, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_project", "blueprint_version_default.json"}), "bp.system.govern_project", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_bundle", "blueprint_version_default.json"}), "bp.system.govern_bundle", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model_version", "blueprint_version_default.json"}), "bp.system.govern_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"business_initiative", "blueprint_version_default.json"}), "bp.system.business_initiative", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersionSignoffConfigurations(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_model_version", "blueprint_version_default_signoff.json"}), "bp.system.govern_model_version", "bv.system.default", actionId, migrationTS);
        MigrationEntitiesUtilsBetweenV12200AndV13099.upsertBlueprintVersionSignoffConfigurations(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{"govern_bundle", "blueprint_version_default_signoff.json"}), "bp.system.govern_bundle", "bv.system.default", actionId, migrationTS);
    }

    @Override
    public boolean shouldPerformDbOptimizationAfterMigration() {
        return false;
    }

    protected static class ToMigrateArtifactSignoff {
        public String blueprintId;
        public String versionId;
        public JsonObject artifactSignoff;

        protected ToMigrateArtifactSignoff() {
        }

        public ToMigrateArtifactSignoff setBlueprintId(String blueprintId) {
            this.blueprintId = blueprintId;
            return this;
        }

        public ToMigrateArtifactSignoff setVersionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public ToMigrateArtifactSignoff setArtifactSignoff(JsonObject artifactSignoff) {
            this.artifactSignoff = artifactSignoff;
            return this;
        }
    }

    protected static class MigratedSignoff {
        public JsonObject signoff;

        protected MigratedSignoff() {
        }

        public MigratedSignoff setSignoff(JsonObject signoff) {
            this.signoff = signoff;
            return this;
        }
    }

    protected static class HistoryMigration<T> {
        public JsonObject revision;
        public T entity;

        protected HistoryMigration() {
        }

        public HistoryMigration<T> setRevision(JsonObject revision) {
            this.revision = revision;
            return this;
        }

        public HistoryMigration<T> setEntity(T entity) {
            this.entity = entity;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoryMigration that = (HistoryMigration)o;
            return Objects.equals(this.revision, that.revision) && Objects.equals(this.entity, that.entity);
        }

        public int hashCode() {
            return Objects.hash(this.revision, this.entity);
        }
    }

    protected static class ToMigrateBlueprintVersionSignoffsConfigurations {
        public JsonObject blueprintVersionSignoffsConfigurations;

        protected ToMigrateBlueprintVersionSignoffsConfigurations() {
        }

        public ToMigrateBlueprintVersionSignoffsConfigurations setBlueprintVersionSignoffsConfigurations(JsonObject blueprintVersionSignoffsConfigurations) {
            this.blueprintVersionSignoffsConfigurations = blueprintVersionSignoffsConfigurations;
            return this;
        }
    }

    protected static class MigratedSignoffConfiguration {
        public JsonObject signoffConfiguration;

        protected MigratedSignoffConfiguration() {
        }

        public MigratedSignoffConfiguration setSignoffConfiguration(JsonObject signoffConfiguration) {
            this.signoffConfiguration = signoffConfiguration;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MigratedSignoffConfiguration that = (MigratedSignoffConfiguration)o;
            return Objects.equals(this.signoffConfiguration, that.signoffConfiguration);
        }

        public int hashCode() {
            return Objects.hash(this.signoffConfiguration);
        }
    }
}

