/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.search_artifacts;

import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import com.dataiku.gh.core.models.dss.DSSDeployerArtifactsContainer;
import com.dataiku.gh.core.models.dss.DSSProjectArtifactsContainer;
import com.dataiku.gh.core.models.dss.DataikuSourceObjects;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DSSIntegrationUtils {
    public static DSSProjectArtifactsContainer mapSearchResultToDSSContainer(List<EnrichedArtifact> enrichedArtifacts) {
        DSSProjectArtifactsContainer existingArtifacts = new DSSProjectArtifactsContainer();
        enrichedArtifacts.forEach(ea -> {
            if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_PROJECT.blueprintId)) {
                existingArtifacts.setProject(ea.artifact, false);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_BUNDLE.blueprintId)) {
                existingArtifacts.addBundle(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_DATASET.blueprintId)) {
                existingArtifacts.addDataset(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId)) {
                existingArtifacts.addSavedModel(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.blueprintId)) {
                existingArtifacts.addRetrievableKnowledge(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.blueprintId)) {
                existingArtifacts.addSavedModelVersion(ea.artifact);
            }
        });
        return existingArtifacts;
    }

    public static DataikuSourceObjects.DataikuSourceProject mapDSSProjectContainerToDataikuObjectSources(DSSProjectArtifactsContainer container) {
        DataikuSourceObjects.DataikuSourceProject sourceProject = new DataikuSourceObjects.DataikuSourceProject();
        if (container.getDSSProject() != null) {
            sourceProject.projectSourceArtifactId = container.getDSSProject().artifact.id;
        }
        sourceProject.dataikuBundlesArtifactsIds.addAll(container.getDSSBundles().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        sourceProject.dataikuDatasetsArtifactsIds.addAll(container.getDSSDatasets().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        Set savedModelIds = container.getDSSSavedModels().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(savedModelIds)) {
            Map<String, List<DSSArtifactContainer.DSSSavedModelVersionArtifactContainer>> modelVersionsByParent = container.getDSSSavedModelVersions().values().stream().filter(dssArtifactContainer -> StringUtils.isNotBlank((String)((String)dssArtifactContainer.artifact.fields.get("dataiku_saved_model")))).collect(Collectors.groupingBy(dssArtifactContainer -> (String)dssArtifactContainer.artifact.fields.get("dataiku_saved_model")));
            for (String savedModelId : savedModelIds) {
                DataikuSourceObjects.DataikuSourceModel sourceModel = new DataikuSourceObjects.DataikuSourceModel();
                sourceModel.modelSourceArtifactId = savedModelId;
                sourceModel.dataikuSourceModelVersionArtifactIds.addAll(modelVersionsByParent.getOrDefault(savedModelId, Collections.emptyList()).stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
                sourceProject.dataikuSourceModels.add(sourceModel);
            }
        }
        sourceProject.dataikuSourceRetrievableKnowledges.addAll(container.getDSSRetrievableKnowledges().values().stream().map(dssArtifactContainer -> dssArtifactContainer.artifact.id).collect(Collectors.toSet()));
        return sourceProject;
    }

    public static DSSDeployerArtifactsContainer mapDeployerSearchResultToContainer(List<EnrichedArtifact> enrichedArtifacts) {
        DSSDeployerArtifactsContainer existingArtifacts = new DSSDeployerArtifactsContainer();
        enrichedArtifacts.forEach(ea -> {
            if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.API_DEPLOYER_INFRA.blueprintId)) {
                existingArtifacts.addAPIInfra(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.blueprintId)) {
                existingArtifacts.addProjectInfra(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.blueprintId)) {
                existingArtifacts.addAPIDeployment(ea.artifact);
            } else if (StringUtils.equals((String)ea.blueprint.id, (String)SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.blueprintId)) {
                existingArtifacts.addProjectDeployment(ea.artifact);
            }
        });
        return existingArtifacts;
    }
}

