/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.assignments;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.assignments.ArtifactRoleAssignments;
import com.dataiku.gh.core.services.artifacts.IArtifactHistoryAwareService;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IArtifactRoleAssignmentsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IRoleAssignmentsValidationService;
import com.dataiku.gh.core.utils.Either;
import java.io.IOException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArtifactRoleAssignmentsService
implements IArtifactRoleAssignmentsService {
    @Autowired
    private IArtifactHistoryAwareService artifactHistoryAwareService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;
    @Autowired
    private IArtifactRoleAssignmentsDataService artifactRoleAssignmentsDataService;
    @Autowired
    private IRoleAssignmentsValidationService roleAssignmentsValidationService;

    @Override
    @GHReadonlyTransaction
    public ArtifactRoleAssignments getArtifactRoleAssignments(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        this.checkArtifactAdminAccess(authCtx, artifactId);
        return this.artifactRoleAssignmentsDataService.getArtifactRoleAssignments(artifactId);
    }

    @Override
    @GHReadonlyTransaction
    @Nullable
    public ArtifactRoleAssignments getArtifactRoleAssignmentsOrNull(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        this.checkArtifactAdminAccess(authCtx, artifactId);
        return this.artifactRoleAssignmentsDataService.getArtifactRoleAssignmentsOrNull(artifactId);
    }

    @Override
    @GHWriteTransaction
    public ArtifactRoleAssignments createArtifactRoleAssignments(AuthCtx authCtx, ArtifactRoleAssignments artifactRoleAssignments) throws IOException, DKUSecurityException {
        this.checkArtifactAdminAccess(authCtx, artifactRoleAssignments.artifactId);
        this.roleAssignmentsValidationService.validateArtifactRoleAssignments(artifactRoleAssignments);
        return this.artifactRoleAssignmentsDataService.createArtifactRoleAssignments(artifactRoleAssignments);
    }

    @Override
    @GHWriteTransaction
    public ArtifactRoleAssignments saveArtifactRoleAssignments(AuthCtx authCtx, ArtifactRoleAssignments artifactRoleAssignments) throws IOException, DKUSecurityException {
        this.checkArtifactAdminAccess(authCtx, artifactRoleAssignments.artifactId);
        this.roleAssignmentsValidationService.validateArtifactRoleAssignments(artifactRoleAssignments);
        return this.artifactRoleAssignmentsDataService.saveArtifactRoleAssignments(artifactRoleAssignments);
    }

    @Override
    @GHWriteTransaction
    public void deleteArtifactRoleAssignments(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        this.checkArtifactAdminAccess(authCtx, artifactId);
        this.artifactRoleAssignmentsDataService.deleteArtifactRoleAssignments(artifactId);
    }

    private void checkArtifactAdminAccess(AuthCtx authCtx, String artifactId) throws IOException, DKUSecurityException {
        Either<EnrichedArtifact, EnrichedDeletedArtifact> artifact = this.artifactHistoryAwareService.getHistoryAwareArtifact(artifactId);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.artifactHistoryAwareService.computeAssignedRolesAndPermissionsCtx(authCtx, artifact);
        this.checkPermissionsService.checkArtifactAdminPermission(authCtx, assignedRolesAndPermissionsCtx.effectivePermissionsItem, artifactId);
    }
}

