/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.signoff;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.signoff.EnrichedSignoff;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffIdAndBPVId;
import com.dataiku.gh.core.models.signoff.search.SignoffPagination;
import com.dataiku.gh.core.models.signoff.search.SignoffSearchConfig;
import com.dataiku.gh.core.services.signoff.ISignoffsDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.storage.signoff.ISignoffDAO;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignoffsDataService
implements ISignoffsDataService {
    @Autowired
    private IBlueprintDAO blueprintDAO;
    @Autowired
    private IBlueprintVersionDAO blueprintVersionDAO;
    @Autowired
    private IBlueprintVersionTraceDAO blueprintVersionTraceDAO;
    @Autowired
    private IArtifactDAO artifactDAO;
    @Autowired
    private ISignoffDAO signoffDAO;
    @Autowired
    private ISignoffsConfigurationsDAO signoffsConfigurationsDAO;

    @Override
    @GHMandatoryTransaction
    public EnrichedSignoff getSignoff(SignoffId signoffId) throws IOException {
        return (EnrichedSignoff)this.signoffDAO.getMandatory(signoffId);
    }

    @Override
    @GHMandatoryTransaction
    public EnrichedSignoff createSignoff(Signoff signoff) throws IOException {
        this.signoffDAO.create(signoff);
        return this.getSignoff(signoff.signoffId);
    }

    @Override
    @GHMandatoryTransaction
    public EnrichedSignoff storeSignoff(Signoff signoff) throws IOException {
        this.signoffDAO.save(signoff);
        return this.getSignoff(signoff.signoffId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteSignoff(SignoffId signoffId) throws IOException {
        this.signoffDAO.delete(signoffId);
    }

    @Override
    @GHMandatoryTransaction
    public List<EnrichedSignoff> fastListSignoffsContaining(String token) throws IOException {
        return this.signoffDAO.listByJsonContainingJsonToken(token);
    }

    @Override
    @GHMandatoryTransaction
    public SignoffConfiguration getSignoffConfiguration(SignoffConfigurationId signoffConfigurationId) throws IOException {
        return (SignoffConfiguration)this.signoffsConfigurationsDAO.getMandatory(signoffConfigurationId);
    }

    @Override
    @GHMandatoryTransaction
    public List<SignoffConfiguration> listSignoffsConfigurations() throws IOException {
        return this.signoffsConfigurationsDAO.list();
    }

    @Override
    @GHMandatoryTransaction
    public List<SignoffConfiguration> listSignoffsConfigurationsByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        return this.signoffsConfigurationsDAO.listByBlueprintVersion(blueprintVersionId);
    }

    @Override
    @GHMandatoryTransaction
    public SignoffConfiguration storeSignoffConfiguration(SignoffConfiguration signoffConfiguration, boolean creation) throws IOException {
        if (creation) {
            this.signoffsConfigurationsDAO.create(signoffConfiguration);
        } else {
            this.signoffsConfigurationsDAO.save(signoffConfiguration);
        }
        return (SignoffConfiguration)this.signoffsConfigurationsDAO.getMandatory(signoffConfiguration.id);
    }

    @Override
    @GHMandatoryTransaction
    public void storeSignoffsConfigurations(List<SignoffConfiguration> signoffsConfigurations, boolean creation) throws IOException {
        if (CollectionUtils.isEmpty(signoffsConfigurations)) {
            return;
        }
        for (SignoffConfiguration signoffConfiguration : signoffsConfigurations) {
            if (creation) {
                this.signoffsConfigurationsDAO.create(signoffConfiguration);
                continue;
            }
            this.signoffsConfigurationsDAO.save(signoffConfiguration);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteSignoffConfiguration(SignoffConfigurationId signoffConfigurationId) throws IOException {
        this.signoffsConfigurationsDAO.delete(signoffConfigurationId);
    }

    @Override
    @GHMandatoryTransaction
    public void deleteSignoffConfigurationsByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        for (SignoffConfiguration signoffConfiguration : this.signoffsConfigurationsDAO.listByBlueprintVersion(blueprintVersionId)) {
            this.signoffsConfigurationsDAO.delete(signoffConfiguration.id);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteSignoffConfigurationsForNonExistingSteps(BlueprintVersionId blueprintVersionId, List<String> existingStepIds) throws IOException {
        for (SignoffConfiguration signoffConfiguration : this.signoffsConfigurationsDAO.listForNonExistingSteps(blueprintVersionId, existingStepIds)) {
            this.signoffsConfigurationsDAO.delete(signoffConfiguration.id);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteSignoffsForNonExistingSteps(BlueprintVersionId blueprintVersionId, List<String> existingStepIds) throws IOException {
        try (Stream<EnrichedSignoff> signoffsToDelete = this.signoffDAO.listForNonExistingSteps(blueprintVersionId, existingStepIds);){
            signoffsToDelete.forEach(signoffToDelete -> {
                try {
                    this.signoffDAO.delete(signoffToDelete.signoff.signoffId);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    @Override
    @GHMandatoryTransaction
    public List<SignoffIdAndBPVId> findScheduledSignoffsToReset() throws IOException {
        return this.signoffDAO.findScheduledSignoffsToReset();
    }

    @Override
    @GHMandatoryTransaction
    public boolean isSignoffScheduledToReset(SignoffId signoffId) throws IOException {
        return this.signoffDAO.isSignoffScheduledToReset(signoffId);
    }

    @Override
    @GHMandatoryTransaction
    public void lockSignoff(SignoffIdAndBPVId signoffIdAndBPVId) throws IOException {
        this.blueprintDAO.lock(signoffIdAndBPVId.blueprintVersionId.blueprintId);
        this.blueprintVersionDAO.lock(signoffIdAndBPVId.blueprintVersionId);
        this.blueprintVersionTraceDAO.lock(signoffIdAndBPVId.blueprintVersionId);
        this.artifactDAO.lock(signoffIdAndBPVId.signoffId.artifactId);
        this.signoffsConfigurationsDAO.lock(SignoffConfigurationId.build(signoffIdAndBPVId.blueprintVersionId, signoffIdAndBPVId.signoffId.stepId));
        this.signoffDAO.lock(signoffIdAndBPVId.signoffId);
    }

    @Override
    public Stream<EnrichedSignoff> searchSignoffsStream(SignoffSearchConfig signoffSearchConfig, SignoffPagination signoffPagination) throws IOException {
        return this.signoffDAO.searchSignoffsStream(signoffSearchConfig, signoffPagination);
    }
}

