/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.services.validation.validators.FieldLogicValidator;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.util.Objects;

public class ArtifactFilterValidator
extends FieldLogicValidator
implements ArtifactFilter.IArtifactFilterVisitor {
    @Override
    public boolean shouldVisitChildren() {
        return true;
    }

    @Override
    public void visit(ArtifactFilter.BlueprintsArtifactFilter blueprintsArtifactFilter) {
        for (String blueprintId : blueprintsArtifactFilter.blueprintIds) {
            ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintId(blueprintId), "Invalid blueprintId: " + blueprintId + " provided in 'blueprintIds' on filter of type 'blueprints'", new Object[0]);
        }
    }

    @Override
    public void visit(ArtifactFilter.BlueprintVersionsArtifactFilter blueprintVersionArtifactFilter) {
        for (int i = 0; i < blueprintVersionArtifactFilter.blueprintVersionIds.size(); ++i) {
            BlueprintVersionId bpId = blueprintVersionArtifactFilter.blueprintVersionIds.get(i);
            ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintId(bpId.blueprintId), "Field invalid: 'blueprintVersionIds." + i + ".blueprintId: " + bpId.blueprintId + ", on filter of type 'blueprintVersions'", new Object[0]);
            ValidatorUtils.validateThat(IdentifiersUtils.isValidBlueprintVersionId(bpId.versionId), "Field invalid: 'blueprintVersionIds." + i + ".versionId: " + bpId.versionId + ", on filter of type 'blueprintVersions'", new Object[0]);
        }
    }

    @Override
    public void visit(ArtifactFilter.ArtifactsArtifactFilter artifactsArtifactFilter) {
        for (String artifactId : artifactsArtifactFilter.artifactIds) {
            ValidatorUtils.validateThat(IdentifiersUtils.isValidArtifactId(artifactId), "Invalid artifactId: " + artifactId + " provided in 'artifactIds' on filter of type 'artifacts'", new Object[0]);
        }
    }

    @Override
    public void visit(ArtifactFilter.ArtifactIdFilter artifactIdFilter) {
        ValidatorUtils.validateThat(artifactIdFilter.condition != null, "Field required: 'condition', on filter of type 'id-as-text'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.ArtifactNameFilter artifactNameFilter) {
        ValidatorUtils.validateThat(artifactNameFilter.condition != null, "Field required: 'condition', on filter of type 'name'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.FieldValueArtifactFilter fieldValueArtifactFilter) {
        ValidatorUtils.validateThat(fieldValueArtifactFilter.conditionType != null, "Field required: 'conditionType', on filter of type 'field'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter) {
        ValidatorUtils.validateThat(typedFieldValueArtifactFilter.fieldId != null, "Field required: 'fieldId', on filter of type 'typed-field'", new Object[0]);
        ValidatorUtils.validateThat(typedFieldValueArtifactFilter.fieldLogic != null, "Field required: 'fieldLogic', on filter of type 'typed-field'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.WorkflowStepArtifactFilter workflowStepArtifactFilter) {
        ValidatorUtils.validateThat(workflowStepArtifactFilter.status != null, "Field required: 'status', on filter of type 'workflow-step'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
        ValidatorUtils.validateThat(signoffStatusArtifactFilter.status != null, "Field required: 'status', on filter of type 'signoff'", new Object[0]);
    }

    @Override
    public void visit(ArtifactFilter.TypedFieldOrArtifactFilter typedFieldOrArtifactFilter) {
        ValidatorUtils.validateThat(typedFieldOrArtifactFilter.fieldId != null, "Field required: 'fieldId', on filter of type 'typed-field-or'", new Object[0]);
        if (typedFieldOrArtifactFilter.textFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.textFilter.getFieldType() == FieldType.TEXT, "'textFilter' must only contain Text field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.textFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'textFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.numberFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.numberFilter.getFieldType() == FieldType.NUMBER, "'numberFilter' must only contain Number field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.numberFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'numberFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.categoryFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.categoryFilter.getFieldType() == FieldType.CATEGORY, "'categoryFilter' must only contain Category field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.categoryFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'categoryFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.dateFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.dateFilter.getFieldType() == FieldType.DATE, "'dateFilter' must only contain Date field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.dateFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'dateFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.referenceFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.referenceFilter.getFieldType() == FieldType.REFERENCE, "'referenceFilter' must only contain Reference field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.referenceFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'referenceFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.booleanFilter != null) {
            ValidatorUtils.validateThat(typedFieldOrArtifactFilter.booleanFilter.getFieldType() == FieldType.BOOLEAN, "'booleanFilter' must only contain Boolean field logic", new Object[0]);
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.booleanFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'booleanFilter' must have same fieldId as root fieldId", new Object[0]);
        }
        if (typedFieldOrArtifactFilter.plaintextFilter != null) {
            ValidatorUtils.validateThat(Objects.equals(typedFieldOrArtifactFilter.plaintextFilter.fieldId, typedFieldOrArtifactFilter.fieldId), "'booleanFilter' must have same fieldId as root fieldId", new Object[0]);
        }
    }
}

