/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TableFeatures {
    private static final Set<String> SUPPORTED_WRITER_FEATURES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("appendOnly");
            this.add("inCommitTimestamp");
            this.add("typeWidening-preview");
            this.add("typeWidening");
            this.add(TableFeatures.DOMAIN_METADATA_FEATURE_NAME);
        }
    });
    private static final Set<String> SUPPORTED_READER_FEATURES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("columnMapping");
            this.add("deletionVectors");
            this.add("timestampNtz");
            this.add("typeWidening-preview");
            this.add("typeWidening");
            this.add("vacuumProtocolCheck");
            this.add("variantType-preview");
            this.add("v2Checkpoint");
        }
    });
    public static final String DOMAIN_METADATA_FEATURE_NAME = "domainMetadata";
    public static final int TABLE_FEATURES_MIN_WRITER_VERSION = 7;

    public static void validateReadSupportedTable(Protocol protocol, String string, Optional<Metadata> optional) {
        switch (protocol.getMinReaderVersion()) {
            case 1: {
                break;
            }
            case 2: {
                optional.ifPresent(ColumnMapping::throwOnUnsupportedColumnMappingMode);
                break;
            }
            case 3: {
                List<String> list = protocol.getReaderFeatures();
                if (!SUPPORTED_READER_FEATURES.containsAll(list)) {
                    HashSet<String> hashSet = new HashSet<String>(list);
                    hashSet.removeAll(SUPPORTED_READER_FEATURES);
                    throw DeltaErrors.unsupportedReaderFeature(string, hashSet);
                }
                if (!list.contains("columnMapping")) break;
                optional.ifPresent(ColumnMapping::throwOnUnsupportedColumnMappingMode);
                break;
            }
            default: {
                throw DeltaErrors.unsupportedReaderProtocol(string, protocol.getMinReaderVersion());
            }
        }
    }

    public static void validateWriteSupportedTable(Protocol protocol, Metadata metadata, StructType structType, String string) {
        int n = protocol.getMinWriterVersion();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                TableFeatures.validateNoInvariants(structType);
                break;
            }
            case 3: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 4: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 5: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 6: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
            case 7: {
                for (String string2 : protocol.getWriterFeatures()) {
                    if (SUPPORTED_WRITER_FEATURES.contains(string2)) continue;
                    throw DeltaErrors.unsupportedWriterFeature(string, string2);
                }
                break;
            }
            default: {
                throw DeltaErrors.unsupportedWriterProtocol(string, n);
            }
        }
    }

    public static Tuple2<Integer, Integer> minProtocolVersionFromAutomaticallyEnabledFeatures(Set<String> set) {
        int n = 0;
        int n2 = 0;
        for (String string : set) {
            n = Math.max(n, TableFeatures.getMinReaderVersion(string));
            n2 = Math.max(n2, TableFeatures.getMinWriterVersion(string));
        }
        return new Tuple2<Integer, Integer>(n, n2);
    }

    public static Set<String> extractAutomaticallyEnabledWriterFeatures(Metadata metadata, Protocol protocol) {
        return SUPPORTED_WRITER_FEATURES.stream().filter(string -> TableFeatures.metadataRequiresWriterFeatureToBeEnabled(metadata, string)).filter(string -> protocol.getWriterFeatures() == null || !protocol.getWriterFeatures().contains(string)).collect(Collectors.toSet());
    }

    public static boolean isDomainMetadataSupported(Protocol protocol) {
        List<String> list = protocol.getWriterFeatures();
        if (list == null) {
            return false;
        }
        return list.contains(DOMAIN_METADATA_FEATURE_NAME) && protocol.getMinWriterVersion() >= 7;
    }

    private static int getMinReaderVersion(String string) {
        switch (string) {
            case "inCommitTimestamp": {
                return 3;
            }
        }
        return 1;
    }

    private static int getMinWriterVersion(String string) {
        switch (string) {
            case "inCommitTimestamp": {
                return 7;
            }
        }
        return 2;
    }

    private static boolean metadataRequiresWriterFeatureToBeEnabled(Metadata metadata, String string) {
        switch (string) {
            case "inCommitTimestamp": {
                return TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(metadata);
            }
        }
        return false;
    }

    private static void validateNoInvariants(StructType structType) {
        boolean bl = structType.fields().stream().anyMatch(structField -> structField.getMetadata().contains("delta.invariants"));
        if (bl) {
            throw DeltaErrors.columnInvariantsNotSupported();
        }
    }
}

