/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonWebServiceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicAWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.RawMessage;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.VersionInfoUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Hashtable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class AWSJavaMailTransport
extends Transport {
    public static final String AWS_EMAIL_SERVICE_ENDPOINT_PROPERTY = "mail.aws.host";
    public static final String AWS_SECRET_KEY_PROPERTY = "mail.aws.password";
    public static final String AWS_ACCESS_KEY_PROPERTY = "mail.aws.user";
    private AmazonSimpleEmailServiceClient emailService;
    private final String accessKey;
    private final String secretKey;
    private final String httpsEndpoint;
    private String lastMessageId;
    private static final String USER_AGENT = AWSJavaMailTransport.class.getName() + "/" + VersionInfoUtils.getVersion();

    public AWSJavaMailTransport(Session session, URLName urlname) {
        super(session, urlname);
        this.accessKey = session.getProperty(AWS_ACCESS_KEY_PROPERTY);
        this.secretKey = session.getProperty(AWS_SECRET_KEY_PROPERTY);
        this.httpsEndpoint = session.getProperty(AWS_EMAIL_SERVICE_ENDPOINT_PROPERTY);
    }

    public void sendMessage(Message msg, Address[] addresses) throws MessagingException, SendFailedException {
        this.checkConnection();
        this.checkMessage(msg);
        this.checkAddresses(msg, addresses);
        this.collateRecipients(msg, addresses);
        SendRawEmailRequest req = this.prepareEmail(msg);
        this.sendEmail(msg, req);
    }

    private void checkConnection() {
        if (this.emailService == null || !super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private void checkMessage(Message msg) throws MessagingException {
        if (msg == null) {
            throw new MessagingException("Message is null");
        }
        if (!(msg instanceof MimeMessage)) {
            throw new MessagingException("AWS Mail Service can only send MimeMessages");
        }
    }

    private void checkAddresses(Message m, Address[] addresses) throws MessagingException, SendFailedException {
        if (AWSJavaMailTransport.isNullOrEmpty(addresses) && AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.TO)) && AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.CC)) && AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.BCC))) {
            throw new SendFailedException("No recipient addresses");
        }
        HashSet<Object> invalid = new HashSet<Object>();
        for (Object[] objectArray : new Address[][]{m.getRecipients(Message.RecipientType.TO), m.getRecipients(Message.RecipientType.CC), m.getRecipients(Message.RecipientType.BCC), addresses}) {
            if (AWSJavaMailTransport.isNullOrEmpty(objectArray)) continue;
            for (Object a : objectArray) {
                if (a instanceof InternetAddress) continue;
                invalid.add(a);
            }
        }
        if (!invalid.isEmpty()) {
            Address[] sent = new Address[]{};
            Address[] unsent = new Address[]{};
            super.notifyTransportListeners(2, sent, unsent, invalid.toArray(new Address[invalid.size()]), m);
            throw new SendFailedException("AWS Mail Service can only send to InternetAddresses");
        }
    }

    private void collateRecipients(Message m, Address[] addresses) throws MessagingException {
        if (!AWSJavaMailTransport.isNullOrEmpty(addresses)) {
            Hashtable<Address, Message.RecipientType> addressTable = new Hashtable<Address, Message.RecipientType>();
            for (Address a : addresses) {
                addressTable.put(a, Message.RecipientType.TO);
            }
            if (!AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.TO))) {
                for (Address a : m.getRecipients(Message.RecipientType.TO)) {
                    addressTable.put(a, Message.RecipientType.TO);
                }
            }
            if (!AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.CC))) {
                for (Address a : m.getRecipients(Message.RecipientType.CC)) {
                    addressTable.put(a, Message.RecipientType.CC);
                }
            }
            if (!AWSJavaMailTransport.isNullOrEmpty(m.getRecipients(Message.RecipientType.BCC))) {
                for (Address a : m.getRecipients(Message.RecipientType.BCC)) {
                    addressTable.put(a, Message.RecipientType.BCC);
                }
            }
            m.setRecipients(Message.RecipientType.TO, new Address[0]);
            m.setRecipients(Message.RecipientType.CC, new Address[0]);
            m.setRecipients(Message.RecipientType.BCC, new Address[0]);
            for (Address a : addressTable.keySet()) {
                m.addRecipient((Message.RecipientType)addressTable.get(a), a);
            }
            if (m.getRecipients(Message.RecipientType.TO) == null || m.getRecipients(Message.RecipientType.TO).length == 0) {
                m.setRecipient(Message.RecipientType.TO, (Address)addressTable.keySet().iterator().next());
            }
        }
    }

    private SendRawEmailRequest prepareEmail(Message m) throws MessagingException {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            m.writeTo((OutputStream)byteOutput);
            SendRawEmailRequest req = new SendRawEmailRequest();
            byte[] messageByteArray = byteOutput.toByteArray();
            RawMessage message = new RawMessage();
            message.setData(ByteBuffer.wrap(messageByteArray));
            req.setRawMessage(message);
            return req;
        }
        catch (Exception e) {
            Address[] sent = new Address[]{};
            Address[] unsent = new Address[]{};
            Address[] invalid = m.getAllRecipients();
            super.notifyTransportListeners(2, sent, unsent, invalid, m);
            throw new MessagingException("Unable to write message: " + m.toString(), e);
        }
    }

    private void sendEmail(Message m, SendRawEmailRequest req) throws SendFailedException, MessagingException {
        Address[] sent = null;
        Address[] unsent = null;
        Address[] invalid = null;
        try {
            this.appendUserAgent(req, USER_AGENT);
            SendRawEmailResult resp = this.emailService.sendRawEmail(req);
            this.lastMessageId = resp.getMessageId();
            sent = m.getAllRecipients();
            unsent = new Address[]{};
            invalid = new Address[]{};
            super.notifyTransportListeners(1, sent, unsent, invalid, m);
        }
        catch (Exception e) {
            sent = new Address[]{};
            unsent = m.getAllRecipients();
            invalid = new Address[]{};
            super.notifyTransportListeners(2, sent, unsent, invalid, m);
            throw new SendFailedException("Unable to send email", e, sent, unsent, invalid);
        }
    }

    protected boolean protocolConnect(String host, int port, String awsAccessKey, String awsSecretKey) {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        if (AWSJavaMailTransport.isNullOrEmpty(awsAccessKey) || AWSJavaMailTransport.isNullOrEmpty(awsSecretKey)) {
            if (AWSJavaMailTransport.isNullOrEmpty(this.accessKey) || AWSJavaMailTransport.isNullOrEmpty(this.secretKey)) {
                this.emailService = new AmazonSimpleEmailServiceClient();
            }
            awsAccessKey = this.accessKey;
            awsSecretKey = this.secretKey;
        }
        if (this.emailService == null) {
            this.emailService = new AmazonSimpleEmailServiceClient(new BasicAWSCredentials(awsAccessKey, awsSecretKey));
        }
        if (!AWSJavaMailTransport.isNullOrEmpty(host)) {
            this.emailService.setEndpoint(host);
        } else if (this.httpsEndpoint != null) {
            this.emailService.setEndpoint(this.httpsEndpoint);
        }
        super.setConnected(true);
        return true;
    }

    public void close() throws MessagingException {
        super.close();
        this.emailService = null;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static boolean isNullOrEmpty(Object[] o) {
        return o == null || o.length == 0;
    }

    public <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }
}

