#' Removes a file or directory from the folder
#'
#' @param name the identifier of the managed folder
#' @param path path to delete within the managed folder
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderDeletePath <- function(name, path) {
    getPathURL <- dku_intercom__get_jek_or_backend_url("/managed-folders/clear-path")
    ref <- dku__resolve_smart_name(name)

    body <- list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref), path=path)
    resp <- POST(getPathURL, body=body, encode="form", dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to delete file or folder")
}
