(function(){
    'use strict';

    const app = angular.module('dataiku.dashboards.insights');

    app.directive('imageAndInsightDescription', function(TileLoadingState){
        return {
            restrict: 'A',
            scope: {
                hook: '=',
                tile: '='
            },
            link: function($scope){

                if ($scope.tile.tileType !== 'INSIGHT' || $scope.tile.displayMode !== 'IMAGE_AND_INSIGHT_DESC') {
                    return;
                }

                $scope.load = function(resolve) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.COMPLETE;
                    resolve();
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
            }
        };
    });

    app.directive('imageTile', function(TileLoadingState){
        return {
            restrict: 'A',
            scope: {
                hook: '=',
                tile: '='
            },
            link: function($scope){

                if ($scope.tile.tileType !== 'IMAGE' && $scope.tile.displayMode !== 'IMAGE') {
                    return;
                }

                $scope.load = function(resolve) {
                    $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.COMPLETE;
                    resolve();
                };
                $scope.hook.loadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.reloadPromises[$scope.tile.$tileId] = $scope.load;
                $scope.hook.loadStates[$scope.tile.$tileId] = TileLoadingState.WAITING;
            }
        };
    });

    app.directive('imageTileParams', function(TileUtils){
        return {
            templateUrl: '/templates/dashboards/insights/image/image_tile_params.html',
            scope: {
                tile: '='
            },
            link: function($scope, element, attrs){
                $scope.openUploadPictureDialog = TileUtils.openUploadPictureDialog;
            }
        };
    });

})();
