

(function() {
    'use strict';

    angular.module('dataiku.charts')
        .controller('EditCustomPaletteModalController', EditCustomPaletteModalController);

    /**
     * (!) This controller previously was in static/dataiku/js/simple_report/common/colors.js
     */
    function EditCustomPaletteModalController($scope, DataikuAPI, $filter, $timeout, StateUtils, FutureProgressModal, ColorUtils, WT1, translate) {
        let originalPalette;

        $scope.uiState = {};
        $scope.exportOptions = {};

        $scope.paletteInvalidMessage = translate('COMPONENT.COLOR_PALETTE.MODAL.INVALID_MESSAGE', 'Colors are required and must be valid hexadecimal, rgb(a) or CSS values.');
        $scope.noChangeMessage = translate('COMPONENT.COLOR_PALETTE.MODAL.NO_CHANGE_MESSAGE', 'No changes to be saved');

        $scope.init = function(palette, paletteType, specifyValuesEnabled = true) {
            $scope.palette = angular.copy(palette);
            $scope.defaultColors = ColorUtils.getDiscretePaletteColors('dku_font');
            originalPalette = angular.copy(palette);
            $scope.paletteType = paletteType;
            $scope.specifyValuesEnabled = specifyValuesEnabled;
            $scope.isDirty = false;
            $scope.isPaletteColorsFormValid = true;
        };

        $scope.save = function() {
            $scope.resolveModal($scope.palette);
        };

        $scope.$watch('palette', function(nv) {
            $scope.isDirty = originalPalette && !_.isEqual(nv, originalPalette);
        }, _.isEqual);

        $scope.codeMirrorOptions = {
            mode: 'application/javascript',
            lineNumbers: false,
            readOnly: true,
            onLoad: function(instance) {
                instance.on('focus', function() {
                    instance.execCommand('selectAll');
                });
            }
        };

        $scope.handlePaletteChange = function(palette) {
            $timeout(() => {
                $scope.palette = palette;
            });
        };

        $scope.handleValidityChange = function(validity) {
            $timeout(() => {
                $scope.isPaletteColorsFormValid = validity === 'VALID';
            });
        };

        const getJsSnippet = function(type, id, name, colors, values) {
            let clippedValues;
            if (values && values.length) {
                clippedValues = values.concat();
                clippedValues.length = colors.length;
            }

            return 'dkuColorPalettes.add' + $filter('capitalize')(type.toLowerCase()) + '({'
                + '\n    "id": ' + JSON.stringify(id) + ','
                + '\n    "name": ' + JSON.stringify(name) + ','
                + '\n    "category": "Plugin palettes",'
                + '\n    "colors": ' + JSON.stringify(colors)
                + (clippedValues ? (',\n    "values": ' + JSON.stringify(clippedValues)) : '')
                + '\n});';
        };

        $scope.updateSnippet = function() {
            $scope.jsSnippet = getJsSnippet($scope.paletteType, $scope.exportOptions.paletteId, $scope.exportOptions.paletteName, $scope.palette.colors, $scope.palette.values);
        };

        $scope.prepareExport = function() {
            $scope.updateSnippet();
            $scope.uiState.exporting = true;
        };

        $scope.export = function() {
            DataikuAPI.plugindev.create($scope.exportOptions.pluginId, 'EMPTY')
                .error(setErrorInScope.bind($scope))
                .success(function(data) {
                    FutureProgressModal.show($scope, data, 'Creating plugin').then(function(result) {
                        if (result) {
                            WT1.event('plugin-dev-create');
                            DataikuAPI.plugindev.createContent($scope.exportOptions.pluginId, '/js', true)
                                .error(setErrorInScope.bind($scope))
                                .success(function() {
                                    DataikuAPI.plugindev.createContent($scope.exportOptions.pluginId, '/js/palette.js', false)
                                        .error(setErrorInScope.bind($scope))
                                        .success(function() {
                                            DataikuAPI.plugindev.setContent($scope.exportOptions.pluginId, '/js/palette.js', $scope.jsSnippet)
                                                .error(setErrorInScope.bind($scope))
                                                .success(function() {
                                                    $scope.dismiss();
                                                    StateUtils.go.pluginDefinition($scope.exportOptions.pluginId);
                                                });
                                        });
                                });
                        }
                    });
                });
        };
    }
})();
