from dataiku.eda.types import Literal

import numpy as np
import pandas as pd

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.computations.timeseries.time_series_computation import format_iso8601
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import MinTimeModel, MinTimeResultModel


class MinTime(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["min_time"]:
        return "min_time"

    @staticmethod
    def build(params: MinTimeModel) -> 'MinTime':
        return MinTime(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> MinTimeResultModel:
        dates = idf.date_col(self.column)
        min_date = np.min(dates)

        if min_date is pd.NaT:
            raise NoDataError()

        return {
            "type": MinTime.get_type(),
            "timestamp": format_iso8601(min_date),
        }
