import numpy as np
from scipy import spatial

def score(y_valid, y_pred, eval_df, output_df, ref_sample_df=None, sample_weight=None, **kwargs):
    """
    Computes data drift on 'some_numerical_column' using Jensen-Shannon distance.
    """
    
    # Data used for current evaluation, from Evaluation Dataset
    evaluation_data = output_df['some_numerical_column']
    
    # Data used to train the model.
    # Mind this is only a sample, its size might differ from evaluation_data
    train_data = ref_sample_df['some_numerical_column']
    
    # Create decile distributions:
    num_bins = 10
    min_edge = min(evaluation_data.min(), train_data.min())
    max_edge = max(evaluation_data.max(), train_data.max())
    evaluation_distribution, _ = np.histogram(evaluation_data, bins=num_bins, range=(min_edge, max_edge))
    train_distribution, _ = np.histogram(train_data, bins=num_bins, range=(min_edge, max_edge))
    
    # Use scipy's implementation of Jensen-Shannon. Normalisation will be done automatically
    return spatial.distance.jensenshannon(evaluation_distribution, train_distribution)
