/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFutures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.SettableApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.DefaultBufferedReadableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GapicUnbufferedReadableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GzipReadableByteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResponseContentLifecycleManager;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.StorageByteChannels;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.UnbufferedReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectResponse;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.concurrent.Immutable;

@Immutable
final class GapicDownloadSessionBuilder {
    private static final GapicDownloadSessionBuilder INSTANCE = new GapicDownloadSessionBuilder();
    private static final int DEFAULT_BUFFER_CAPACITY = 0x1000000;

    private GapicDownloadSessionBuilder() {
    }

    public static GapicDownloadSessionBuilder create() {
        return INSTANCE;
    }

    public ReadableByteChannelSessionBuilder byteChannel(ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ResponseContentLifecycleManager responseContentLifecycleManager) {
        return new ReadableByteChannelSessionBuilder(read, responseContentLifecycleManager);
    }

    public static final class ReadableByteChannelSessionBuilder {
        private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
        private final ResponseContentLifecycleManager responseContentLifecycleManager;
        private boolean autoGzipDecompression;
        private Hasher hasher;

        private ReadableByteChannelSessionBuilder(ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ResponseContentLifecycleManager responseContentLifecycleManager) {
            this.read = read;
            this.responseContentLifecycleManager = responseContentLifecycleManager;
            this.hasher = Hasher.noop();
            this.autoGzipDecompression = false;
        }

        public BufferedReadableByteChannelSessionBuilder buffered() {
            return this.buffered(BufferHandle.allocate(0x1000000));
        }

        public ReadableByteChannelSessionBuilder setHasher(Hasher hasher) {
            this.hasher = hasher;
            return this;
        }

        public ReadableByteChannelSessionBuilder setAutoGzipDecompression(boolean autoGzipDecompression) {
            this.autoGzipDecompression = autoGzipDecompression;
            return this;
        }

        public BufferedReadableByteChannelSessionBuilder buffered(BufferHandle bufferHandle) {
            return new BufferedReadableByteChannelSessionBuilder(bufferHandle, this.bindFunction());
        }

        public BufferedReadableByteChannelSessionBuilder buffered(ByteBuffer buffer) {
            return this.buffered(BufferHandle.handleOf(buffer));
        }

        public UnbufferedReadableByteChannelSessionBuilder unbuffered() {
            return new UnbufferedReadableByteChannelSessionBuilder(this.bindFunction());
        }

        private BiFunction<ReadObjectRequest, SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> bindFunction() {
            Hasher hasher = this.hasher;
            boolean autoGzipDecompression = this.autoGzipDecompression;
            return (object, resultFuture) -> {
                if (autoGzipDecompression) {
                    return new GzipReadableByteChannel(new GapicUnbufferedReadableByteChannel((SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>)resultFuture, this.read, (ReadObjectRequest)object, hasher, this.responseContentLifecycleManager), ApiFutures.transform(resultFuture, com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object::getContentEncoding, MoreExecutors.directExecutor()));
                }
                return new GapicUnbufferedReadableByteChannel((SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>)resultFuture, this.read, (ReadObjectRequest)object, hasher, this.responseContentLifecycleManager);
            };
        }

        public static final class BufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ReadObjectRequest, SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>, BufferedReadableByteChannelSession.BufferedReadableByteChannel> f;
            private ReadObjectRequest request;

            private BufferedReadableByteChannelSessionBuilder(BufferHandle buffer, BiFunction<ReadObjectRequest, SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f.andThen(c -> new DefaultBufferedReadableByteChannel(buffer, (UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel)c));
            }

            public BufferedReadableByteChannelSessionBuilder setReadObjectRequest(ReadObjectRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public BufferedReadableByteChannelSession<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object> build() {
                return new ChannelSession.BufferedReadSession<ReadObjectRequest, com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }

        public static final class UnbufferedReadableByteChannelSessionBuilder {
            private final BiFunction<ReadObjectRequest, SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f;
            private ReadObjectRequest request;

            private UnbufferedReadableByteChannelSessionBuilder(BiFunction<ReadObjectRequest, SettableApiFuture<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>, UnbufferedReadableByteChannelSession.UnbufferedReadableByteChannel> f) {
                this.f = f;
            }

            public UnbufferedReadableByteChannelSessionBuilder setReadObjectRequest(ReadObjectRequest request) {
                this.request = Objects.requireNonNull(request, "request must be non null");
                return this;
            }

            public UnbufferedReadableByteChannelSession<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object> build() {
                return new ChannelSession.UnbufferedReadSession<ReadObjectRequest, com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object>(ApiFutures.immediateFuture(this.request), this.f.andThen(StorageByteChannels.readable()::createSynchronized));
            }
        }
    }
}

