/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.BitSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public abstract class HiveFilterJoinRule
extends FilterJoinRule {
    public static final HiveFilterJoinRule FILTER_ON_JOIN = new HiveFilterJoinMergeRule();
    public static final HiveFilterJoinRule JOIN = new HiveFilterJoinTransposeRule();

    protected HiveFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelBuilderFactory relBuilderFactory) {
        super(operand, id, smart, relBuilderFactory, TRUE_PREDICATE);
    }

    private boolean filterRefersToBothSidesOfJoin(RexNode filter, Join j) {
        boolean refersToBothSides = false;
        int joinNoOfProjects = j.getRowType().getFieldCount();
        ImmutableBitSet filterProjs = (ImmutableBitSet)ImmutableBitSet.FROM_BIT_SET.apply(new BitSet(joinNoOfProjects));
        ImmutableBitSet allLeftProjs = filterProjs.union(ImmutableBitSet.range((int)0, (int)j.getInput(0).getRowType().getFieldCount()));
        ImmutableBitSet allRightProjs = filterProjs.union(ImmutableBitSet.range((int)j.getInput(0).getRowType().getFieldCount(), (int)joinNoOfProjects));
        if (allLeftProjs.intersects(filterProjs = filterProjs.union(RelOptUtil.InputFinder.bits((RexNode)filter))) && allRightProjs.intersects(filterProjs)) {
            refersToBothSides = true;
        }
        return refersToBothSides;
    }

    public static class HiveFilterJoinTransposeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinTransposeRule() {
            super(RelOptRule.operand(Join.class, (RelOptRuleOperandChildren)RelOptRule.any()), "HiveFilterJoinRule:no-filter", true, HiveRelFactories.HIVE_BUILDER);
        }

        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            List joinConds = RelOptUtil.conjunctions((RexNode)join.getCondition());
            for (RexNode joinCnd : joinConds) {
                if (HiveCalciteUtil.isDeterministic(joinCnd)) continue;
                return false;
            }
            return true;
        }

        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            super.perform(call, null, join);
        }
    }

    public static class HiveFilterJoinMergeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinMergeRule() {
            super(RelOptRule.operand(Filter.class, (RelOptRuleOperand)RelOptRule.operand(Join.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "HiveFilterJoinRule:filter", true, HiveRelFactories.HIVE_BUILDER);
        }

        public boolean matches(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            return HiveCalciteUtil.isDeterministic(filter.getCondition());
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            super.perform(call, filter, join);
        }
    }
}

