/*
 * Decompiled with CFR 0.152.
 */
package net.sf.spnego;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.logging.Logger;
import net.sourceforge.spnego.SpnegoHttpFilter;

public class SpnegoHttpSessionFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(SpnegoHttpSessionFilter.class.getName());
    private String httpSessAttribName = "spnegoAuthNuser";
    private final transient SpnegoHttpFilter spnego = new SpnegoHttpFilter();

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("SpnegoHttpSessionFilter::init");
        this.spnego.init(filterConfig);
        String tmp = filterConfig.getInitParameter("http.sess.attib.name");
        if (null != tmp && !tmp.isBlank()) {
            this.httpSessAttribName = tmp;
        }
    }

    public void destroy() {
        this.spnego.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession httpSession = httpRequest.getSession(false);
        if (null == httpSession || null == httpSession.getAttribute(this.httpSessAttribName)) {
            LOGGER.fine("SpnegoHttpSessionFilter::doFilter no session");
            this.spnego.doFilter(request, response, chain);
        } else {
            LOGGER.fine("SpnegoHttpSessionFilter::doFilter HAS session");
            chain.doFilter(request, response);
        }
    }
}

