/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time.ical;

import com.dataiku.dip.shaker.processors.time.ical.HolidayOccurrence;
import com.dataiku.dip.shaker.processors.time.ical.HolidaysFinder;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class HolidaysFinderCombiner
implements HolidaysFinder {
    private final HolidaysFinder[] finders;

    public HolidaysFinderCombiner(HolidaysFinder ... finders) {
        this.finders = finders;
    }

    @Override
    public List<HolidayOccurrence> searchForDay(int year, int month, int day, String selectedCalendar) {
        ArrayList<HolidayOccurrence> out = new ArrayList<HolidayOccurrence>();
        for (HolidaysFinder finder : this.finders) {
            out.addAll(finder.searchForDay(year, month, day, selectedCalendar));
        }
        return out;
    }

    @Override
    public List<HolidayOccurrence> searchForDay(DateTime date, String selectedCalendar) {
        ArrayList<HolidayOccurrence> out = new ArrayList<HolidayOccurrence>();
        for (HolidaysFinder finder : this.finders) {
            out.addAll(finder.searchForDay(date, selectedCalendar));
        }
        return out;
    }

    @Override
    public List<String> listAvailableCalendars() {
        HashSet<String> calendars = new HashSet<String>();
        for (HolidaysFinder finder : this.finders) {
            calendars.addAll(finder.listAvailableCalendars());
        }
        return new ArrayList<String>(calendars);
    }
}

