/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.shaker.types.AbstractLongMeaning;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Locale;

public class Date
extends AbstractLongMeaning {
    private static final DateTimeParser DECIMAL_PARSER = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('.').toParser(), new DateTimeFormatterBuilder().appendLiteral(',').toParser()}).appendFractionOfSecond(1, 9).toParser();
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().append(ISODateTimeFormat.date()).appendLiteral('T').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).appendOptional(DECIMAL_PARSER).appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
    public static final DateTimeFormatter CANONICAL_FORMATTER = ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC);
    private static final java.time.format.DateTimeFormatter RFC_1123_FORMATTER = java.time.format.DateTimeFormatter.RFC_1123_DATE_TIME;
    private SimpleDateFormat rfc1123FormatterLegacy = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);

    public Date() {
        this.rfc1123FormatterLegacy.setLenient(false);
    }

    @Override
    public String getMeaningId() {
        return "Date";
    }

    @Override
    public boolean isTemporal() {
        return true;
    }

    private static boolean isInvalidIsoDatetime(String s) {
        if (!(Date.areDigits(s, 0, 3) && s.charAt(4) == '-' && Date.areDigits(s, 5, 6) && s.charAt(7) == '-' && Date.areDigits(s, 8, 9) && s.charAt(10) == 'T' && Date.areDigits(s, 11, 12) && s.charAt(13) == ':' && Date.areDigits(s, 14, 15) && s.charAt(16) == ':' && Date.areDigits(s, 17, 18))) {
            return true;
        }
        for (int i = 19; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != 'Z' && c != '+' && c != '-') continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithDayOfWeek(String input) {
        char firstChar = input.charAt(0);
        char secondChar = input.charAt(1);
        char thirdChar = input.charAt(2);
        switch (firstChar) {
            case 'M': {
                return secondChar == 'o' && thirdChar == 'n';
            }
            case 'T': {
                switch (secondChar) {
                    case 'u': {
                        return thirdChar == 'e';
                    }
                    case 'h': {
                        return thirdChar == 'u';
                    }
                }
                return false;
            }
            case 'W': {
                return secondChar == 'e' && thirdChar == 'd';
            }
            case 'F': {
                return secondChar == 'r' && thirdChar == 'i';
            }
            case 'S': {
                switch (secondChar) {
                    case 'a': {
                        return thirdChar == 't';
                    }
                    case 'u': {
                        return thirdChar == 'n';
                    }
                }
                return false;
            }
        }
        return false;
    }

    public long msSinceEpoch(String v) {
        if (v == null || v.isEmpty()) {
            return Long.MAX_VALUE;
        }
        int length = v.length();
        if (length > 50) {
            return Long.MAX_VALUE;
        }
        if (length >= 19 && !Date.isInvalidIsoDatetime(v)) {
            try {
                return ISO_FORMATTER.parseMillis(v);
            }
            catch (Exception e) {
                return Long.MAX_VALUE;
            }
        }
        if (length >= 15 && Date.startsWithDayOfWeek(v)) {
            try {
                return ZonedDateTime.parse(v, RFC_1123_FORMATTER).toInstant().toEpochMilli();
            }
            catch (Exception e1) {
                try {
                    return this.rfc1123FormatterLegacy.parse(v).getTime();
                }
                catch (Exception e2) {
                    return Long.MAX_VALUE;
                }
            }
        }
        return Long.MAX_VALUE;
    }

    @Override
    public double detects(String val) {
        return this.msSinceEpoch(val) == Long.MAX_VALUE ? 0.0 : 0.9;
    }

    @Override
    public long longValue(String v) {
        return this.msSinceEpoch(v);
    }

    @Override
    public double doubleValue(String v) {
        long lv = this.longValue(v);
        if (lv == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return lv;
    }

    private static boolean areDigits(String s, int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

