/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.codecs;

import com.dataiku.dss.shadelib.org.apache.lucene.codecs.DocValuesProducer;
import com.dataiku.dss.shadelib.org.apache.lucene.index.BinaryDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocIDMerger;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DocValuesType;
import com.dataiku.dss.shadelib.org.apache.lucene.index.EmptyDocValuesProducer;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FieldInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FilteredTermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.ImpactsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MergeState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.NumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.OrdinalMap;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedNumericDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SortedSetDocValues;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermState;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.AttributeSource;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import com.dataiku.dss.shadelib.org.apache.lucene.util.LongBitSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.LongValues;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DocValuesConsumer
implements Closeable {
    protected DocValuesConsumer() {
    }

    public abstract void addNumericField(FieldInfo var1, DocValuesProducer var2) throws IOException;

    public abstract void addBinaryField(FieldInfo var1, DocValuesProducer var2) throws IOException;

    public abstract void addSortedField(FieldInfo var1, DocValuesProducer var2) throws IOException;

    public abstract void addSortedNumericField(FieldInfo var1, DocValuesProducer var2) throws IOException;

    public abstract void addSortedSetField(FieldInfo var1, DocValuesProducer var2) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (DocValuesProducer docValuesProducer : mergeState.docValuesProducers) {
            if (docValuesProducer == null) continue;
            docValuesProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            DocValuesType type = mergeFieldInfo.getDocValuesType();
            if (type == DocValuesType.NONE) continue;
            if (type == DocValuesType.NUMERIC) {
                this.mergeNumericField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.BINARY) {
                this.mergeBinaryField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED) {
                this.mergeSortedField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED_SET) {
                this.mergeSortedSetField(mergeFieldInfo, mergeState);
                continue;
            }
            if (type == DocValuesType.SORTED_NUMERIC) {
                this.mergeSortedNumericField(mergeFieldInfo, mergeState);
                continue;
            }
            throw new AssertionError((Object)("type=" + type));
        }
    }

    public void mergeNumericField(final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addNumericField(mergeFieldInfo, new EmptyDocValuesProducer(){

            @Override
            public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                ArrayList<NumericDocValuesSub> subs = new ArrayList<NumericDocValuesSub>();
                assert (mergeState.docMaps.length == mergeState.docValuesProducers.length);
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    NumericDocValues values2 = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                        values2 = docValuesProducer.getNumeric(readerFieldInfo);
                    }
                    if (values2 == null) continue;
                    subs.add(new NumericDocValuesSub(mergeState.docMaps[i], values2));
                }
                return DocValuesConsumer.mergeNumericValues(subs, mergeState.needsIndexSort);
            }
        });
    }

    private static NumericDocValues mergeNumericValues(List<NumericDocValuesSub> subs, boolean indexIsSorted) throws IOException {
        long cost = 0L;
        for (NumericDocValuesSub sub : subs) {
            cost += sub.values.cost();
        }
        final long finalCost = cost;
        final DocIDMerger<NumericDocValuesSub> docIDMerger = DocIDMerger.of(subs, indexIsSorted);
        return new NumericDocValues(){
            private int docID = -1;
            private NumericDocValuesSub current;

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = (NumericDocValuesSub)docIDMerger.next();
                this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docID;
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                return finalCost;
            }

            @Override
            public long longValue() throws IOException {
                return this.current.values.longValue();
            }
        };
    }

    public void mergeBinaryField(final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addBinaryField(mergeFieldInfo, new EmptyDocValuesProducer(){

            @Override
            public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>();
                long cost = 0L;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    DocIdSetIterator values2 = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                        values2 = docValuesProducer.getBinary(readerFieldInfo);
                    }
                    if (values2 == null) continue;
                    cost += values2.cost();
                    subs.add(new BinaryDocValuesSub(mergeState.docMaps[i], (BinaryDocValues)values2));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                final long finalCost = cost;
                return new BinaryDocValues(){
                    private BinaryDocValuesSub current;
                    private int docID = -1;

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        this.current = (BinaryDocValuesSub)docIDMerger.next();
                        this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                        return this.docID;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long cost() {
                        return finalCost;
                    }

                    @Override
                    public BytesRef binaryValue() throws IOException {
                        return this.current.values.binaryValue();
                    }
                };
            }
        });
    }

    public void mergeSortedNumericField(final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        this.addSortedNumericField(mergeFieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedNumericDocValuesSub> subs = new ArrayList<SortedNumericDocValuesSub>();
                long cost = 0L;
                boolean allSingletons = true;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    SortedNumericDocValues values2 = null;
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                        values2 = docValuesProducer.getSortedNumeric(readerFieldInfo);
                    }
                    if (values2 == null) {
                        values2 = DocValues.emptySortedNumeric();
                    }
                    cost += values2.cost();
                    if (allSingletons && DocValues.unwrapSingleton(values2) == null) {
                        allSingletons = false;
                    }
                    subs.add(new SortedNumericDocValuesSub(mergeState.docMaps[i], values2));
                }
                if (allSingletons) {
                    ArrayList<NumericDocValuesSub> singleValuedSubs = new ArrayList<NumericDocValuesSub>();
                    for (SortedNumericDocValuesSub sub : subs) {
                        NumericDocValues singleValuedValues = DocValues.unwrapSingleton(sub.values);
                        assert (singleValuedValues != null);
                        singleValuedSubs.add(new NumericDocValuesSub(sub.docMap, singleValuedValues));
                    }
                    return DocValues.singleton(DocValuesConsumer.mergeNumericValues(singleValuedSubs, mergeState.needsIndexSort));
                }
                final long finalCost = cost;
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                return new SortedNumericDocValues(){
                    private int docID = -1;
                    private SortedNumericDocValuesSub currentSub;

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        this.currentSub = (SortedNumericDocValuesSub)docIDMerger.next();
                        this.docID = this.currentSub == null ? Integer.MAX_VALUE : this.currentSub.mappedDocID;
                        return this.docID;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int docValueCount() {
                        return this.currentSub.values.docValueCount();
                    }

                    @Override
                    public long cost() {
                        return finalCost;
                    }

                    @Override
                    public long nextValue() throws IOException {
                        return this.currentSub.values.nextValue();
                    }
                };
            }
        });
    }

    public void mergeSortedField(final FieldInfo fieldInfo, final MergeState mergeState) throws IOException {
        ArrayList<SortedDocValues> toMerge = new ArrayList<SortedDocValues>();
        for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            FieldInfo readerFieldInfo;
            SortedDocValues values2 = null;
            DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
            if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                values2 = docValuesProducer.getSorted(readerFieldInfo);
            }
            if (values2 == null) {
                values2 = DocValues.emptySorted();
            }
            toMerge.add(values2);
        }
        int numReaders = toMerge.size();
        SortedDocValues[] dvs = toMerge.toArray(new SortedDocValues[numReaders]);
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < numReaders; ++sub) {
            int docID;
            SortedDocValues dv = dvs[sub];
            Bits liveDocs = mergeState.liveDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            while ((docID = dv.nextDoc()) != Integer.MAX_VALUE) {
                int ord;
                if (!liveDocs.get(docID) || (ord = dv.ordValue()) < 0) continue;
                bitset.set(ord);
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final OrdinalMap map = OrdinalMap.build(null, liveTerms, weights, 0.0f);
        this.addSortedField(fieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedDocValues getSorted(FieldInfo fieldInfoIn) throws IOException {
                if (fieldInfoIn != fieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedDocValuesSub> subs = new ArrayList<SortedDocValuesSub>();
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    SortedDocValues values2 = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                        values2 = docValuesProducer.getSorted(readerFieldInfo);
                    }
                    if (values2 == null) {
                        values2 = DocValues.emptySorted();
                    }
                    subs.add(new SortedDocValuesSub(mergeState.docMaps[i], values2, map.getGlobalOrds(i)));
                }
                return DocValuesConsumer.mergeSortedValues(subs, mergeState.needsIndexSort, map);
            }
        });
    }

    private static SortedDocValues mergeSortedValues(final List<SortedDocValuesSub> subs, boolean indexIsSorted, final OrdinalMap map) throws IOException {
        long cost = 0L;
        for (SortedDocValuesSub sub : subs) {
            cost += sub.values.cost();
        }
        final long finalCost = cost;
        final DocIDMerger<SortedDocValuesSub> docIDMerger = DocIDMerger.of(subs, indexIsSorted);
        return new SortedDocValues(){
            private int docID = -1;
            private SortedDocValuesSub current;

            @Override
            public int docID() {
                return this.docID;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = (SortedDocValuesSub)docIDMerger.next();
                this.docID = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docID;
            }

            @Override
            public int ordValue() throws IOException {
                int subOrd = this.current.values.ordValue();
                assert (subOrd != -1);
                return (int)this.current.map.get(subOrd);
            }

            @Override
            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                return finalCost;
            }

            @Override
            public int getValueCount() {
                return (int)map.getValueCount();
            }

            @Override
            public BytesRef lookupOrd(int ord) throws IOException {
                int segmentNumber = map.getFirstSegmentNumber(ord);
                int segmentOrd = (int)map.getFirstSegmentOrd(ord);
                return ((SortedDocValuesSub)subs.get((int)segmentNumber)).values.lookupOrd(segmentOrd);
            }

            @Override
            public TermsEnum termsEnum() throws IOException {
                TermsEnum[] termsEnurmSubs = new TermsEnum[subs.size()];
                for (int sub = 0; sub < termsEnurmSubs.length; ++sub) {
                    termsEnurmSubs[sub] = ((SortedDocValuesSub)subs.get((int)sub)).values.termsEnum();
                }
                return new MergedTermsEnum(map, termsEnurmSubs);
            }
        };
    }

    public void mergeSortedSetField(final FieldInfo mergeFieldInfo, final MergeState mergeState) throws IOException {
        final ArrayList<SortedSetDocValues> toMerge = new ArrayList<SortedSetDocValues>();
        for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
            FieldInfo fieldInfo;
            SortedSetDocValues values2 = null;
            DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
            if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                values2 = docValuesProducer.getSortedSet(fieldInfo);
            }
            if (values2 == null) {
                values2 = DocValues.emptySortedSet();
            }
            toMerge.add(values2);
        }
        TermsEnum[] liveTerms = new TermsEnum[toMerge.size()];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < liveTerms.length; ++sub) {
            int docID;
            SortedSetDocValues dv = (SortedSetDocValues)toMerge.get(sub);
            Bits liveDocs = mergeState.liveDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            while ((docID = dv.nextDoc()) != Integer.MAX_VALUE) {
                if (!liveDocs.get(docID)) continue;
                for (int i = 0; i < dv.docValueCount(); ++i) {
                    bitset.set(dv.nextOrd());
                }
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final OrdinalMap map = OrdinalMap.build(null, liveTerms, weights, 0.0f);
        this.addSortedSetField(mergeFieldInfo, new EmptyDocValuesProducer(){

            @Override
            public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
                if (fieldInfo != mergeFieldInfo) {
                    throw new IllegalArgumentException("wrong FieldInfo");
                }
                ArrayList<SortedSetDocValuesSub> subs = new ArrayList<SortedSetDocValuesSub>();
                long cost = 0L;
                boolean allSingletons = true;
                for (int i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    FieldInfo readerFieldInfo;
                    Object values2 = null;
                    DocValuesProducer docValuesProducer = mergeState.docValuesProducers[i];
                    if (docValuesProducer != null && (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && readerFieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                        values2 = docValuesProducer.getSortedSet(readerFieldInfo);
                    }
                    if (values2 == null) {
                        values2 = DocValues.emptySortedSet();
                    }
                    cost += ((DocIdSetIterator)values2).cost();
                    if (allSingletons && DocValues.unwrapSingleton((SortedSetDocValues)values2) == null) {
                        allSingletons = false;
                    }
                    subs.add(new SortedSetDocValuesSub(mergeState.docMaps[i], (SortedSetDocValues)values2, map.getGlobalOrds(i)));
                }
                if (allSingletons) {
                    ArrayList<SortedDocValuesSub> singleValuedSubs = new ArrayList<SortedDocValuesSub>();
                    for (SortedSetDocValuesSub sub : subs) {
                        SortedDocValues singleValuedValues = DocValues.unwrapSingleton(sub.values);
                        assert (singleValuedValues != null);
                        singleValuedSubs.add(new SortedDocValuesSub(sub.docMap, singleValuedValues, sub.map));
                    }
                    return DocValues.singleton(DocValuesConsumer.mergeSortedValues(singleValuedSubs, mergeState.needsIndexSort, map));
                }
                final DocIDMerger docIDMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                final long finalCost = cost;
                return new SortedSetDocValues(){
                    private int docID = -1;
                    private SortedSetDocValuesSub currentSub;

                    @Override
                    public int docID() {
                        return this.docID;
                    }

                    @Override
                    public int nextDoc() throws IOException {
                        this.currentSub = (SortedSetDocValuesSub)docIDMerger.next();
                        this.docID = this.currentSub == null ? Integer.MAX_VALUE : this.currentSub.mappedDocID;
                        return this.docID;
                    }

                    @Override
                    public int advance(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public long nextOrd() throws IOException {
                        long subOrd = this.currentSub.values.nextOrd();
                        if (subOrd == -1L) {
                            return -1L;
                        }
                        return this.currentSub.map.get(subOrd);
                    }

                    @Override
                    public int docValueCount() {
                        return this.currentSub.values.docValueCount();
                    }

                    @Override
                    public long cost() {
                        return finalCost;
                    }

                    @Override
                    public BytesRef lookupOrd(long ord) throws IOException {
                        int segmentNumber = map.getFirstSegmentNumber(ord);
                        long segmentOrd = map.getFirstSegmentOrd(ord);
                        return ((SortedSetDocValues)toMerge.get(segmentNumber)).lookupOrd(segmentOrd);
                    }

                    @Override
                    public long getValueCount() {
                        return map.getValueCount();
                    }

                    @Override
                    public TermsEnum termsEnum() throws IOException {
                        TermsEnum[] subs = new TermsEnum[toMerge.size()];
                        for (int sub = 0; sub < subs.length; ++sub) {
                            subs[sub] = ((SortedSetDocValues)toMerge.get(sub)).termsEnum();
                        }
                        return new MergedTermsEnum(map, subs);
                    }
                };
            }
        });
    }

    public static boolean isSingleValued(Iterable<Number> docToValueCount) {
        for (Number count : docToValueCount) {
            if (count.longValue() <= 1L) continue;
            return false;
        }
        return true;
    }

    public static Iterable<Number> singletonView(final Iterable<Number> docToValueCount, final Iterable<Number> values2, final Number missingValue) {
        assert (DocValuesConsumer.isSingleValued(docToValueCount));
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator countIterator = docToValueCount.iterator();
                final Iterator valuesIterator = values2.iterator();
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return countIterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        int count = ((Number)countIterator.next()).intValue();
                        if (count == 0) {
                            return missingValue;
                        }
                        return (Number)valuesIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        final LongBitSet liveTerms;

        BitsFilteredTermsEnum(TermsEnum in, LongBitSet liveTerms) {
            super(in, false);
            assert (liveTerms != null);
            this.liveTerms = liveTerms;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            if (this.liveTerms.get(this.ord())) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    private static class SortedSetDocValuesSub
    extends DocIDMerger.Sub {
        final SortedSetDocValues values;
        final LongValues map;

        public SortedSetDocValuesSub(MergeState.DocMap docMap, SortedSetDocValues values2, LongValues map) {
            super(docMap);
            this.values = values2;
            this.map = map;
            assert (values2.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }

        public String toString() {
            return "SortedSetDocValuesSub(mappedDocID=" + this.mappedDocID + " values=" + this.values + ")";
        }
    }

    private static class SortedDocValuesSub
    extends DocIDMerger.Sub {
        final SortedDocValues values;
        final LongValues map;

        public SortedDocValuesSub(MergeState.DocMap docMap, SortedDocValues values2, LongValues map) {
            super(docMap);
            this.values = values2;
            this.map = map;
            assert (values2.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class MergedTermsEnum
    extends TermsEnum {
        private final TermsEnum[] subs;
        private final OrdinalMap ordinalMap;
        private final long valueCount;
        private long ord = -1L;
        private BytesRef term;

        MergedTermsEnum(OrdinalMap ordinalMap, TermsEnum[] subs) {
            this.ordinalMap = ordinalMap;
            this.subs = subs;
            this.valueCount = ordinalMap.getValueCount();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public BytesRef next() throws IOException {
            if (++this.ord >= this.valueCount) {
                return null;
            }
            int subNum = this.ordinalMap.getFirstSegmentNumber(this.ord);
            TermsEnum sub = this.subs[subNum];
            long subOrd = this.ordinalMap.getFirstSegmentOrd(this.ord);
            do {
                this.term = sub.next();
            } while (sub.ord() < subOrd);
            assert (sub.ord() == subOrd);
            return this.term;
        }

        @Override
        public AttributeSource attributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean seekExact(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekExact(BytesRef term, TermState state) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public TermState termState() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SortedNumericDocValuesSub
    extends DocIDMerger.Sub {
        final SortedNumericDocValues values;

        public SortedNumericDocValuesSub(MergeState.DocMap docMap, SortedNumericDocValues values2) {
            super(docMap);
            this.values = values2;
            assert (values2.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class BinaryDocValuesSub
    extends DocIDMerger.Sub {
        final BinaryDocValues values;

        public BinaryDocValuesSub(MergeState.DocMap docMap, BinaryDocValues values2) {
            super(docMap);
            this.values = values2;
            assert (values2.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class NumericDocValuesSub
    extends DocIDMerger.Sub {
        final NumericDocValues values;

        public NumericDocValuesSub(MergeState.DocMap docMap, NumericDocValues values2) {
            super(docMap);
            this.values = values2;
            assert (values2.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

