/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search.comparators;

import com.dataiku.dss.shadelib.org.apache.lucene.document.LongPoint;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafFieldComparator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Pruning;
import com.dataiku.dss.shadelib.org.apache.lucene.search.comparators.NumericComparator;
import java.io.IOException;

public class LongComparator
extends NumericComparator<Long> {
    private final long[] values;
    protected long topValue;
    protected long bottom;

    public LongComparator(int numHits, String field, Long missingValue, boolean reverse, Pruning pruning) {
        super(field, missingValue != null ? missingValue : 0L, reverse, pruning, 8);
        this.values = new long[numHits];
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Long.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setTopValue(Long value) {
        super.setTopValue(value);
        this.topValue = value;
    }

    @Override
    public Long value(int slot) {
        return this.values[slot];
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new LongLeafComparator(context);
    }

    public class LongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public LongLeafComparator(LeafReaderContext context) throws IOException {
            super(LongComparator.this, context);
        }

        private long getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return this.docValues.longValue();
            }
            return (Long)LongComparator.this.missingValue;
        }

        @Override
        public void setBottom(int slot) throws IOException {
            LongComparator.this.bottom = LongComparator.this.values[slot];
            super.setBottom(slot);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Long.compare(LongComparator.this.bottom, this.getValueForDoc(doc));
        }

        @Override
        public int compareTop(int doc) throws IOException {
            return Long.compare(LongComparator.this.topValue, this.getValueForDoc(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            LongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        @Override
        protected int compareMissingValueWithBottomValue() {
            return Long.compare((Long)LongComparator.this.missingValue, LongComparator.this.bottom);
        }

        @Override
        protected int compareMissingValueWithTopValue() {
            return Long.compare((Long)LongComparator.this.missingValue, LongComparator.this.topValue);
        }

        @Override
        protected void encodeBottom(byte[] packedValue) {
            LongPoint.encodeDimension(LongComparator.this.bottom, packedValue, 0);
        }

        @Override
        protected void encodeTop(byte[] packedValue) {
            LongPoint.encodeDimension(LongComparator.this.topValue, packedValue, 0);
        }
    }
}

